% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShapeFile.R
\name{ReadShapefile_P00}
\alias{ReadShapefile_P00}
\title{Return x,y coordinates of a tree ring center point (P00) from shape file of tree ring points}
\usage{
ReadShapefile_P00(
  filename = "Abies_277_h400_TreeRing_Points.shp",
  id.tag = "id",
  ring.tag = "ring"
)
}
\arguments{
\item{filename}{a shape file name of Tree ring points}

\item{id.tag}{string, column name of id (attribute table)}

\item{ring.tag}{string, column name of ring years  (0 is cambium layer)}
}
\value{
numeric : x,y coordinates of a tree ring center point (P00)
}
\description{
Return x,y coordinates of a tree ring center point (P00) from shape file of tree ring points
}
\examples{
.dir <- system.file("shp",package = "TreeRingShape")
.file <- "Abies_277_h400_TreeRing_Points.shp"
filename <- paste(.dir,.file,sep="/")
ReadShapefile_P00(filename)
}
