% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_information.R
\name{SplitwiseInfo}
\alias{SplitwiseInfo}
\title{Information content of splits within a tree}
\usage{
SplitwiseInfo(x)
}
\arguments{
\item{x}{A tree of class \code{phylo}, a list of trees, or a \code{multiPhylo} object.}
}
\description{
Sum the phylogenetic information content for all splits within a
phylogenetic tree.  This value will be greater than the total information
content of the tree where a tree contains multiple splits, as
these splits will contain mutual information.
}
\examples{
SplitwiseInfo(TreeTools::PectinateTree(8))
}
\seealso{
An introduction to the phylogenetic information content of a split is given
in \href{https://ms609.github.io/TreeTools/reference/SplitInformation.html}{\code{SplitInformation()}}
and in a \href{https://ms609.github.io/TreeDist/articles/information.html}{package vignette}.

Other information functions: 
\code{\link{ClusteringEntropy}()},
\code{\link{SplitEntropy}()},
\code{\link{SplitSharedInformation}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{information functions}
