% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdjustAlphaScale.R
\name{adjust_alpha_scale}
\alias{adjust_alpha_scale}
\title{Adjust Alpha Scale for Data Visualization}
\usage{
adjust_alpha_scale(data, name, range = c(0.2, 0.8))
}
\arguments{
\item{data}{A data frame containing the values for which the alpha scale is to be adjusted.}

\item{name}{Character string that will be used as the title of the legend in the plot.}

\item{range}{Numeric vector of length 2 specifying the range of alpha values, defaults to c(0.2, 0.8).}
}
\value{
A ggplot2 alpha scale adjustment layer.
}
\description{
This function dynamically adjusts the transparency scale for visualizations,
especially useful when the range of data values varies significantly across different sources.
It modifies the transparency scale based on the range of values present in the data,
ensuring that the visualization accurately reflects variations within the data.
}
\examples{
# Assuming 'data' is a DataFrame with a 'value' column
plot_data <- data.frame(value = c(10, 20, 30, 40, 50))
ggplot2::ggplot(plot_data, ggplot2::aes(x = 1:nrow(plot_data), y = value)) +
  ggplot2::geom_point(ggplot2::aes(alpha = value)) +
  adjust_alpha_scale(plot_data, "Transparency Scale")

}
