% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossSampleEntropy.R
\name{CrossSampleEntropy}
\alias{CrossSampleEntropy}
\title{Angular distance metrics}
\usage{
CrossSampleEntropy(returns_matrix, m = 2, r = 0.2)
}
\arguments{
\item{returns_matrix}{a matrix containing the track records of the underlying assets/strategies. These will be normalized during the algorithm}

\item{m}{an integer value defining the embedding dimension , default value is 2}

\item{r}{a  double  value defining the tolerance, default value is 0.2}
}
\value{
The value of cross sample entropy
}
\description{
Calculates the cross sample entropy between two track records of various assets/strategies.
}
\examples{

## calling CrossSampleEntropy() without an argument loads the historical edhec data
## for the "Short Selling" and "Convertible Arbitrage" strategies
returns_matrix = PerformanceAnalytics::edhec[,c("Short Selling","Convertible Arbitrage")]
Cross_Sample_Entropy = CrossSampleEntropy(returns_matrix,m=2,r=0.2)

}
\references{
https://physoc.onlinelibrary.wiley.com/doi/epdf/10.1113/expphysiol.2007.037150
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
