% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TileScheme.R
\name{TileScheme}
\alias{TileScheme}
\title{Tile Scheme}
\usage{
TileScheme(input, dimByCell = NULL, dimByDist = NULL, buffer = 0,
  bufferspill = FALSE, snap = NULL, removeEmpty = TRUE)
}
\arguments{
\item{input}{filename (character), \link[raster]{extent}, \link[raster]{raster} or a vector of four numbers}

\item{dimByCell}{vector of two numbers. Defines the 'x' and 'y' dimensions of each tile in number of cells. Can only
be used when \code{input} is a raster.}

\item{dimByDist}{vector of two numbers. Defines the 'x' and 'y' dimensions of each tile in the distance unit of
\code{input} (usually meters)}

\item{buffer}{numeric. If set to >0, overlapping buffers will be created around each tile. Defined in cell number or distance unit, depending on the
the usage of \code{dimByCell} or \code{dimByDist} respectively}

\item{bufferspill}{logical. Default is \code{FALSE}, in which case the tiling grid will be pushed inwards so that the
buffers of the outer tiles are within the extent of \code{input}. If set to \code{TRUE}, the buffers will extend outside
of the extent of \code{input}}

\item{snap}{optional. Vector of two numbers corresponding to a pair of coordinates to which the tiling scheme will
be aligned. Can only be used in conjuction with \code{dimByDist}. The coordinates do not need to b within the extent of
\code{input}}

\item{removeEmpty}{logical. Default is \code{FALSE}. If set to \code{TRUE}, tiles containing only \code{NA} cell values
will be removed from the tiling scheme. Can only be used when \code{input} is a Raster object}
}
\value{
The output of this function is a list of three \link[sp]{SpatialPolygonsDataFrame} objects:
  \item{tilePolygons}{The tiling grid. Each polygon corresponds to the extent of a single unbuffered tile.}
  \item{buffPolygons}{The buffered tiling grid. Each polygon corresponds to the extent of a buffered tile. These
  polygons overlap with neighbouring tiles. If \code{buffer} is set to 0, this output will be identical to \code{tilePolygons}.}
  \item{nbuffPolygons}{Non-overlapping buffered tiles. These polygons remove overlapping buffers for adjacent tiles, but
  preserve buffers for tiles on the edges of the tiling grid. Useful for "reassembling" data that had been originally broken
  into tiles.}
}
\description{
This function aims to provide an all-in-one tool for creating tiling schemes, which includes options for overlapping
buffers and methods for describing tile sizes in various ways (i.e. using either distance units or cell numbers).
}

