% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random-tidy-beta.R
\name{tidy_beta}
\alias{tidy_beta}
\title{Tidy Randomly Generated Beta Distribution Tibble}
\usage{
tidy_beta(
  .n = 50,
  .shape1 = 1,
  .shape2 = 1,
  .ncp = 0,
  .num_sims = 1,
  .return_tibble = TRUE
)
}
\arguments{
\item{.n}{The number of randomly generated points you want.}

\item{.shape1}{A non-negative parameter of the Beta distribution.}

\item{.shape2}{A non-negative parameter of the Beta distribution.}

\item{.ncp}{The \verb{non-centrality parameter} of the Beta distribution.}

\item{.num_sims}{The number of randomly generated simulations you want.}

\item{.return_tibble}{A logical value indicating whether to return the result
as a tibble. Default is TRUE.}
}
\value{
A tibble of randomly generated data.
}
\description{
This function will generate \code{n} random points from a beta
distribution with a user provided, \code{.shape1}, \code{.shape2}, \code{.ncp} or \verb{non-centrality parameter},
and number of random simulations to be produced. The function returns a tibble with the
simulation number column the x column which corresponds to the n randomly
generated points, the \code{d_}, \code{p_} and \code{q_} data points as well.

The data is returned un-grouped.

The columns that are output are:
\itemize{
\item \code{sim_number} The current simulation number.
\item \code{x} The current value of \code{n} for the current simulation.
\item \code{y} The randomly generated data point.
\item \code{dx} The \code{x} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{dy} The \code{y} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{p} The values from the resulting p_ function of the distribution family.
\item \code{q} The values from the resulting q_ function of the distribution family.
}
}
\details{
This function uses the underlying \code{stats::rbeta()}, and its underlying
\code{p}, \code{d}, and \code{q} functions. For more information please see \code{\link[stats:Beta]{stats::rbeta()}}
}
\examples{
tidy_beta()

}
\seealso{
\url{https://statisticsglobe.com/beta-distribution-in-r-dbeta-pbeta-qbeta-rbeta}

\url{https://en.wikipedia.org/wiki/Beta_distribution}

Other Continuous Distribution: 
\code{\link{tidy_burr}()},
\code{\link{tidy_cauchy}()},
\code{\link{tidy_chisquare}()},
\code{\link{tidy_exponential}()},
\code{\link{tidy_f}()},
\code{\link{tidy_gamma}()},
\code{\link{tidy_generalized_beta}()},
\code{\link{tidy_generalized_pareto}()},
\code{\link{tidy_geometric}()},
\code{\link{tidy_inverse_burr}()},
\code{\link{tidy_inverse_exponential}()},
\code{\link{tidy_inverse_gamma}()},
\code{\link{tidy_inverse_normal}()},
\code{\link{tidy_inverse_pareto}()},
\code{\link{tidy_inverse_weibull}()},
\code{\link{tidy_logistic}()},
\code{\link{tidy_lognormal}()},
\code{\link{tidy_normal}()},
\code{\link{tidy_paralogistic}()},
\code{\link{tidy_pareto}()},
\code{\link{tidy_pareto1}()},
\code{\link{tidy_t}()},
\code{\link{tidy_triangular}()},
\code{\link{tidy_uniform}()},
\code{\link{tidy_weibull}()},
\code{\link{tidy_zero_truncated_geometric}()}

Other Beta: 
\code{\link{tidy_generalized_beta}()},
\code{\link{util_beta_param_estimate}()},
\code{\link{util_beta_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Beta}
\concept{Continuous Distribution}
