% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RML_limit.R
\name{taNegbin.LimitRestMLE}
\alias{taNegbin.LimitRestMLE}
\title{taNegbin.LimitRestMLE}
\usage{
taNegbin.LimitRestMLE(
  rateExp1,
  rateRef1,
  ratePla1,
  shape1,
  Delta,
  allocation = c(1/3, 1/3, 1/3)
)
}
\arguments{
\item{rateExp1}{A numeric value specifying the rate of the experimental treatment group in the alternative hypothesis}

\item{rateRef1}{A numeric value specifying the rate of the reference treatment group in the alternative hypothesis}

\item{ratePla1}{A numeric value specifying the rate of the placebo treatment group in the alternative hypothesis}

\item{shape1}{A numeric value specifying the shape parameter}

\item{Delta}{A numeric value specifying the non-inferiority/superiority margin}

\item{allocation}{A (non-empty) vector specifying the sample size allocation (wExp, wRef, wPla)}
}
\value{
A list containing the following components:
\item{rateExp0, rateRef0, rateRef0}{The limit of the maximum-likelihood estimator for the rates when estimated restricted to the boundary of the null hypothesis}
\item{shape0}{The limit of the maximum-likelihood estimator for the shape parameter when estimated restricted to the boundary of the null hypothesis}
\item{sigma2.rest}{The limit of the maximum-likelihood variance estimator for the Wald-type test when restricted to the boundary of the null hypothesis}
}
\description{
Limit of restricted maximum-likelihood estimator in case of negative binomial distributed endpoints
}
\keyword{internal}
