% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_core_documents.r, R/RcppExports.R
\name{h_item}
\alias{h_item}
\alias{h_1pl}
\alias{h_2pl}
\alias{h_3pl}
\alias{h_pc}
\alias{h_gpc}
\alias{h_gr}
\alias{array_h_1pl}
\alias{array_h_2pl}
\alias{array_h_3pl}
\alias{array_h_pc}
\alias{array_h_gpc}
\alias{array_h_gr}
\title{(C++) Calculate second derivative of log-likelihood}
\usage{
h_1pl(x, b, u)

h_2pl(x, a, b, u)

h_3pl(x, a, b, c, u)

h_pc(x, b, u)

h_gpc(x, a, b, u)

h_gr(x, a, b, u)

array_h_1pl(x, b, u)

array_h_2pl(x, a, b, u)

array_h_3pl(x, a, b, c, u)

array_h_pc(x, b, u)

array_h_gpc(x, a, b, u)

array_h_gr(x, a, b, u)
}
\arguments{
\item{x}{the theta value. This must be a column vector in matrix form for \code{array_h_*()} functions.}

\item{u}{the response value.}

\item{a, b, c}{the item parameters.}
}
\description{
\code{h_*()} and \code{array_h_*()} are C++ functions for calculating the second derivative of the log-likelihood function.
}
\details{
\code{h_*()} functions accept a single theta value, and \code{array_h_*()} functions accept multiple theta values.

Currently supports unidimensional models.

\itemize{
  \item{\code{h_1pl()}, \code{array_h_1pl()}}: 1PL models
  \item{\code{h_2pl()}, \code{array_h_2pl()}}: 2PL models
  \item{\code{h_3pl()}, \code{array_h_3pl()}}: 3PL models
  \item{\code{h_pc()}, \code{array_h_pc()}}: PC (partial credit) models
  \item{\code{h_gpc()}, \code{array_h_gpc()}}: GPC (generalized partial credit) models
  \item{\code{h_gr()}, \code{array_h_gr()}}: GR (graded response) models
}
}
\examples{
u <- 1

x <- 0.5
h_1pl(x, 1, u)
h_2pl(x, 1, 2, u)
h_3pl(x, 1, 2, 0.25, u)
h_pc(x, c(0, 1), u)
h_gpc(x, 2, c(0, 1), u)
h_gr(x, 2, c(0, 2), u)

x <- matrix(seq(-3, 3, 1)) # column vector in matrix form
array_h_1pl(x, 1, u)
array_h_2pl(x, 1, 2, u)
array_h_3pl(x, 1, 2, 0.25, u)
array_h_pc(x, c(0, 1), u)
array_h_gpc(x, 2, c(0, 1), u)
array_h_gr(x, 2, c(0, 2), u)

}
\references{
Rasch, G. (1960). \emph{Probabilistic models for some intelligence and attainment tests.}
Copenhagen: Danish Institute for Educational Research.

Lord, F. M. (1952). A theory of test scores (Psychometric Monograph No. 7). Richmond, VA: Psychometric Corporation.

Birnbaum, A. (1957). \emph{Efficient design and use of tests of mental ability for various decision-making problems}
(Series Report No. 58-16. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{On the estimation of mental ability}
(Series Report No. 15. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{Further considerations of efficiency in tests of a mental ability}
(Series Report No. 17. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1968). Some latent trait models and their use in inferring an examinee's ability.
In Lord, F. M., Novick, M. R. (eds.), \emph{Statistical Theories of Mental Test Scores}, 397-479.
Reading, MA: Addison-Wesley.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}(2), 149-174.

Andrich, D. (1978). A rating formulation for ordered response categories.
\emph{Psychometrika, 43}(4), 561-573.

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm.
\emph{Applied Psychological Measurement, 16}(2), 159-176.

Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
\emph{Psychometrika Monograph, 17}.
}
