% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset_science}
\alias{dataset_science}
\alias{itempool_science_data}
\alias{itemattrib_science_data}
\alias{constraints_science_data}
\alias{itempool_science}
\alias{itemattrib_science}
\alias{constraints_science}
\title{Science dataset}
\description{
Item-based example item pool (1000 items).
}
\details{
This pool is associated with the following objects:
\itemize{
  \item \code{itempool_science} An \code{\linkS4class{item_pool}} object containing 1000 items.
  \item \code{itemattrib_science} A \code{\linkS4class{item_attrib}} object containing 9 item-level attributes.
  \item \code{constraints_science} A \code{\linkS4class{constraints}} object containing 36 constraints.
}

Also, the following objects are intended for illustrating expected data structures.
\itemize{
  \item \code{itempool_science_data} A \code{\link{data.frame}} containing item parameters.
  \item \code{itemattrib_science_data} A \code{\link{data.frame}} containing item attributes.
  \item \code{constraints_science_data} A \code{\link{data.frame}} containing constraint specifications.
}
}
\examples{
itempool_science    <- loadItemPool(itempool_science_data)
itemattrib_science  <- loadItemAttrib(itemattrib_science_data, itempool_science)
constraints_science <- loadConstraints(constraints_science_data,
  itempool_science, itemattrib_science)

}
\keyword{datasets}
