% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{routes}
\alias{routes}
\alias{getTargomoRoutes}
\alias{drawTargomoRoutes}
\alias{addTargomoRoutes}
\title{Add Targomo Routes to a Leaflet Map}
\usage{
getTargomoRoutes(source_data = NULL, source_lat = NULL,
  source_lng = NULL, target_data = NULL, target_lat = NULL,
  target_lng = NULL, source_id = NULL, target_id = NULL,
  options = targomoOptions(), api_key = Sys.getenv("TARGOMO_API_KEY"),
  region = Sys.getenv("TARGOMO_REGION"), config = list(),
  verbose = FALSE, progress = FALSE, timeout = NULL)

drawTargomoRoutes(map, routes, drawOptions = routeDrawOptions(),
  group = NULL, ...)

addTargomoRoutes(map, source_data = NULL, source_lat = NULL,
  source_lng = NULL, source_id = NULL, target_data = NULL,
  target_lat = NULL, target_lng = NULL, target_id = NULL,
  options = targomoOptions(), drawOptions = routeDrawOptions(),
  group = NULL, api_key = Sys.getenv("TARGOMO_API_KEY"),
  region = Sys.getenv("TARGOMO_REGION"), config = list(),
  verbose = FALSE, progress = FALSE, timeout = NULL)
}
\arguments{
\item{source_data, target_data}{The source and target points for your routes -
supported types are data.frame matrix and objects from the sf and sp packages.}

\item{source_lat, source_lng}{Columns identifying the latitude
and longitude columns in your sourcedata, or numeric vectors of equal length.}

\item{target_lat, target_lng}{As for \code{source_lat,source_lng} but for target data.}

\item{source_id, target_id}{Formulas or vectors of IDs to give to your source and target points.
These will be used to match back to the input data if applicable.}

\item{options}{A list of \code{\link{targomoOptions}} to send to the API.}

\item{api_key}{Your Targomo API key - defaults to the \code{TARGOMO_API_KEY}
ennvironment variable.}

\item{region}{Your Targomo region - defaults to the \code{TARGOMO_REGION}
environment variable.}

\item{config}{Config options to pass to \code{httr::POST} e.g. proxy settings}

\item{verbose}{Whether to print out information about the API call.}

\item{progress}{Whether to show a progress bar of the API call.}

\item{timeout}{Timeout in seconds (leave NULL for no timeout/curl default).}

\item{map}{A leaflet map}

\item{routes}{A list of route segments provided by \code{\link{getTargomoRoutes}}.}

\item{drawOptions}{A list of \code{\link{routeDrawOptions}} to determine how to show
the resulting routes on the map.}

\item{group}{The leaflet map group to add the routes to. One group is used for all
map elements being drawn per call to the API.}

\item{...}{Further arguments to pass to \code{\link[leaflet]{addPolylines}}}
}
\value{
For `get*`, a list of objects of class "sf" containing the routes For `draw*` and `add*`,
  the leaflet map returned with the routes drawn on.
}
\description{
This function takes source and target data, together with options for the API and
drawing options, and returns the map with the requested routes.
}
\examples{
\donttest{
# load leaflet package
library(leaflet)
l <- leaflet()

# get route from Big Ben to Tower Bridge
r <- getTargomoRoutes(source_lat = 51.5007, source_lng = -0.1246,
                      target_lat = 51.5055, target_lng = -0.0754,
                      options = targomoOptions(travelType = c("bike", "transit")))

# draw the routes on the map
l \%>\% drawTargomoRoutes(routes = r)

# note, could combine get.. and draw... into one with add...

}

}
\seealso{
\code{\link{draw-routes}}
}
