% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/addToTree.R
\name{addToTree}
\alias{addToTree}
\title{Adds a set of strings to a ternary search tree}
\usage{
addToTree(tree, input)
}
\arguments{
\item{tree}{an existing ternary search tree to add words to.}

\item{input}{a filepath to read from or a character vector containing the strings.}
}
\value{
An object of class `list` and `tstTree`.
}
\description{
Updates a ternary search tree adding the words or strings from the input
}
\details{
Updates the tree and adds the words contained in a vector or a file. 
Reports each 10000 words it has added to the tree and takes around 
30 sec. per 10k words on a 8Gb RAM computer. 
In addition, reports the number of words added and the total number of nodes 
when finished.
}
\examples{
fruitTree <- newTree(c("apple", "orange"))
fruitTree <- addToTree(fruitTree, c("lemon", "pear"))
}
\seealso{
\code{\link{newTree}}
}

