% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fittestWavelet.r
\name{fittestWavelet}
\alias{fittestWavelet}
\title{Automatic prediction with wavelet transform}
\usage{
fittestWavelet(
  timeseries,
  timeseries.test = NULL,
  h = 1,
  filters = c("haar", "d4", "la8", "bl14", "c6"),
  n.levels = NULL,
  maxlevel = NULL,
  boundary = "periodic",
  model = c("ets", "arima"),
  conf.level = 0.95,
  na.action = stats::na.omit,
  rank.by = c("MSE", "NMSE", "MAPE", "sMAPE", "MaxError", "AIC", "AICc", "BIC",
    "logLik", "errors", "fitness"),
  ...
)
}
\arguments{
\item{timeseries}{A vector or univariate time series.}

\item{timeseries.test}{A vector or univariate time series containing a
continuation for \code{timeseries} with actual values. It is used as a
testing set and base for calculation of prediction error measures. Ignored
if \code{NULL}.}

\item{h}{Number of consecutive values of the time series to be predicted. If
\code{h} is \code{NULL}, the number of consecutive values to be predicted is
assumed to be equal to the length of \code{timeseries.test}. Required when
\code{timeseries.test} is \code{NULL}.}

\item{filters}{A vector containing character strings indicating which
wavelet filter to use in the decomposition. If \code{length(filters)>1}, the
wavelet transform filter used for generating the return of the function is
automatically selected. If \code{NULL}, all supported filters are considered
for automatic selection. See 'Details'. For more details on all the
supported filters and corresponding character strings see
\code{\link[wavelets]{wt.filter}}.}

\item{n.levels}{An integer specifying the level of the decomposition. If
\code{NULL}, the level of the wavelet decomposition returned by the function
is automatically selected within the interval \code{1:maxlevel}. See
'Details'.}

\item{maxlevel}{A numeric integer value corresponding to the maximal level
of candidate wavelet decompositions to be produced and evaluated. If
\code{NULL}, \code{maxlevel} is set as
\code{floor(log(((nobs-1)/(L-1))+1)/log(2))}, where
\code{nobs=length(timeseries)} and \code{L} is the length of the wavelet and
scaling filters. See \code{\link[wavelets]{modwt}} and
\code{\link[wavelets]{wt.filter}}. Ignored if \code{n.levels} is provided.
See 'Details'.}

\item{boundary}{Character string. Indicates which boundary method to use.
See \code{\link[wavelets]{modwt}}.}

\item{model}{Character string. Indicates which model is to be used for
fitting and prediction of the components of the decomposed series.}

\item{conf.level}{Confidence level for prediction intervals. See the
\code{\link[forecast]{forecast}} function of the \code{forecast} package. %%
~~Describe \code{na.action} here~~}

\item{na.action}{A function for treating missing values in \code{timeseries}
and \code{timeseries.test}. The default function is \code{\link[stats]{na.omit}},
which omits any missing values found in \code{timeseries} or
\code{timeseries.test}.}

\item{rank.by}{Character string. Criteria used for ranking candidate
decompositions/models/predictions generated during parameter selection. See
'Details'.}

\item{...}{Additional arguments passed to the modeling functions. %%
~~Describe \code{na.action} here~~}
}
\value{
A list with components: \item{WT}{An object of class
\code{\link[wavelets]{modwt}} containing the wavelet transformed/decomposed
time series.} \item{level}{The level of wavelet decomposition provided or
automatically selected.} \item{filter}{A character string indicating the
(provided or automatically selected) wavelet filter used in the
decomposition.} \item{AICc}{Numeric value of the computed AICc criterion of
the fitted model for the \code{level}th scaling coefficients series.}
\item{AIC}{Numeric value of the computed AIC criterion of the fitted model
for the \code{level}th scaling coefficients series.} \item{BIC}{Numeric
value of the computed BIC criterion of the fitted model for the
\code{level}th scaling coefficients series.} \item{logLik}{Numeric value of
the computed log-likelihood of the fitted model for the \code{level}th
scaling coefficients series.} \item{pred}{A list with the components
\code{mean}, \code{lower} and \code{upper}, containing the predictions based
on the best evaluated decomposition and the lower and upper limits for
prediction intervals, respectively. All components are time series. See the
\code{\link[forecast]{forecast}} function in the \code{forecast} package.}
\item{MSE}{Numeric value of the resulting MSE error of prediction. Require
\code{timeseries.test}.} \item{NMSE}{Numeric value of the resulting NMSE
error of prediction. Require \code{timeseries.test}.} \item{MAPE}{Numeric
value of the resulting MAPE error of prediction. Require
\code{timeseries.test}.} \item{sMAPE}{Numeric value of the resulting sMAPE
error of prediction. Require \code{timeseries.test}.}
\item{MaxError}{Numeric value of the maximal error of prediction. Require
\code{timeseries.test}.} \item{rank.val}{Data.frame with the fitness or
prediction accuracy criteria computed based on all candidate decompositions
ranked by \code{rank.by}. It has the attribute \code{"ranked.wt"}, which is
a list of \code{\link[wavelets]{modwt}} objects containing all the candidate
decompositions, also ranked by \code{rank.by}. Only provided if
\code{filters} or \code{n.levels} were automatically selected.}
\item{rank.by}{Ranking criteria used for ranking candidate decompositions
and producing \code{rank.val}.}
}
\description{
The function automatically applies a maximal overlap discrete wavelet
transform to a provided univariate time series. The resulting components of
the decomposed series are used as base for predicting and returning the next
n consecutive values of the provided univariate time series using also
automatically fitted models (\code{\link{ets}} or \code{\link{arima}}). It
also evaluates fitness and prediction accuracy of the produced models.
}
\details{
The function produces a maximal overlap discrete wavelet transform of
\code{timeseries}. It performs a time series decomposition of level
\code{n.levels} using the wavelet filter \code{filters}. See the
\code{\link[wavelets]{modwt}} function. Each component series resulting from
the decomposition (\code{n.levels} wavelet coefficients series and
\code{n.levels} scaling coefficients series) is separately used as base for
model fitting and prediction. If \code{model="arima"}, arima models are used
and automatically fitted using the \code{\link[forecast]{auto.arima}}
function. If \code{model="ets"}, the function fits
\code{[forecast]\link{ets}} models. The set of predictions for all component
series are then reversed transformed in order to produce the next \code{h}
consecutive values of the provided univariate time series in
\code{timeseries}. See the \code{\link[wavelets]{imodwt}} function.

If \code{length(filters)>1} or \code{filters=NULL}, it is automatically
selected. For that, a set of candidate wavelet decompositions with different
options of filters is generated and used for model fitting and prediction.
Also, if \code{n.levels} is \code{NULL}, it is automatically set as a value
within the interval \code{1:maxlevel} (if \code{maxlevel} is not provided,
it is calculated according to the wavelet filter based on code from
\code{\link[wavelets]{modwt}}). For that, candidate decompositions are
specified with different levels. The options of filter and/or level of
decomposition which generate the best ranked model fitness/predictions
acoording to the criteria in \code{rank.by} are selected.

The ranking criteria in \code{rank.by} may be set as a prediction error
measure (such as \code{\link{MSE}}, \code{\link{NMSE}}, \code{\link{MAPE}},
\code{\link{sMAPE}} or \code{\link{MAXError}}), or as a fitness criteria
(such as \code{\link{AIC}}, \code{\link{AICc}}, \code{\link{BIC}} or
\code{\link{logLik}}). In the former case, the candidate wavelet
decompositions are used for time series prediction and the error measures
are calculated by means of a cross-validation process. In the latter case,
the component series of the candidate decompositions are modeled and model
fitness criteria are calculated based on all observations in
\code{timeseries}. In particular, the fitness criteria calculated for
ranking the candidate decomposition correspond to the model produced for the
\code{n.levels}th scaling coefficients series as it can be considered the
main component of a decomposition of level \code{n.levels} (Conejo,2005).

If \code{rank.by} is set as \code{"errors"} or \code{"fitness"}, the
candidate decompositions are ranked by all the mentioned prediction error
measures or fitness criteria, respectively. The wheight of the ranking
criteria is equally distributed. In this case, a \code{rank.position.sum}
criterion is produced for ranking the candidate decompositions. The
\code{rank.position.sum} criterion is calculated as the sum of the rank
positions of a decomposition (1 = 1st position = better ranked model, 2 =
2nd position, etc.) on each calculated ranking criteria.
}
\examples{

data(CATS)
\donttest{
fW <- fittestWavelet(CATS[,1],h=20,model="arima")

#plot wavelet transform/decomposition
plot(fW$WT)
}

}
\references{
A. J. Conejo, M. A. Plazas, R. Espinola, A. B. Molina, Day-ahead
electricity price forecasting using the wavelet transform and ARIMA models,
IEEE Transactions on Power Systems 20 (2005) 1035-1042.

T. Joo, S. Kim, Time series forecasting based on wavelet filtering, Expert
Systems with Applications 42 (2015) 3868-3874.

C. Stolojescu, I. Railean, S. M. P. Lenca, A. Isar, A wavelet based
prediction method for time series. In Proceedings of the 2010 International
Conference Stochastic Modeling Techniques and Data Analysis, Chania, Greece
(pp. 8-11) (2010). %% ~put references to the literature/web site here ~
}
\seealso{
\code{\link{fittestEMD}}, \code{\link{fittestMAS}} ~
}
\author{
Rebecca Pontes Salles
}
\keyword{adjustment}
\keyword{automatic}
\keyword{criterion}
\keyword{decomposition}
\keyword{errors}
\keyword{evaluation}
\keyword{fitting}
\keyword{prediction}
\keyword{series}
\keyword{time}
\keyword{transform}
\keyword{wavelet}
