% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspred.r
\name{evaluate.tspred}
\alias{evaluate.tspred}
\title{Evaluate method for \code{\link{tspred}} objects}
\usage{
\method{evaluate}{tspred}(obj, fitness = TRUE, ...)
}
\arguments{
\item{obj}{An object of class \code{\link{tspred}} defining a particular time series prediction process.}

\item{fitness}{Should the function compute fitness quality metrics?}

\item{...}{Other parameters passed to the method \code{\link{evaluate}} of
the \code{\link{evaluating}} objects from \code{obj}.}
}
\value{
An object of class \code{tspred} with updated structure containing
computed quality metric values.
}
\description{
Evaluates the modeling fitness and quality of time series prediction of the trained models and
predicted time series data contained in a \code{\link{tspred}} class object, respectively,
based on a particular metric. Each metric is defined
by an \code{\link{evaluating}} object in the list contained in the \code{\link{tspred}} class object.
}
\details{
The function \code{\link{evaluate.tspred}} calls the method \code{\link{evaluate}}
on each \code{\link{evaluating}} object contained in \code{obj}. It uses each trained model,
the testing set and the time series predictions contained in \code{obj} to compute the metrics.
Finally, the produced quality metrics are introduced in the structure of the \code{\link{tspred}}
class object in \code{obj}.
}
\examples{
\donttest{
data(CATS)

#Obtaining objects of the processing class
proc1 <- subsetting(test_len=20)
proc2 <- BoxCoxT(lambda=NULL)
proc3 <- WT(level=1, filter="bl14")

#Obtaining objects of the modeling class
modl1 <- ARIMA()

#Obtaining objects of the evaluating class
eval1 <- MSE_eval()

#Defining a time series prediction process
tspred_1 <- tspred(subsetting=proc1,
                   processing=list(BCT=proc2,
                                   WT=proc3),
                   modeling=modl1,
                   evaluating=list(MSE=eval1)
)
summary(tspred_1)

tspred_1 <- subset(tspred_1, data=CATS[3])
tspred_1 <- preprocess(tspred_1,prep_test=FALSE)
tspred_1 <- train(tspred_1)
tspred_1 <- predict(tspred_1, onestep=TRUE)
tspred_1 <- postprocess(tspred_1)
tspred_1 <- evaluate(tspred_1)
}

}
\seealso{
[tspred()] for defining a particular time series prediction process,
and [MSE_eval()] for defining a time series prediction/modeling quality metric.

Other evaluate: 
\code{\link{evaluate}()}
}
\author{
Rebecca Pontes Salles
}
\concept{evaluate}
\keyword{evaluation}
\keyword{metric}
\keyword{quality}
