% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Discriminant.R
\name{KFCV.WaveAnalysis}
\alias{KFCV.WaveAnalysis}
\title{KFCV}
\usage{
\method{KFCV}{WaveAnalysis}(data, grps, method, k = 5L, returnClassification = FALSE, ...)
}
\arguments{
\item{data}{WaveAnalysis (MWA) object obtained with MultiWaveAnalysis and
preferably obtained a subset of its characteristics
(\code{\link{StepDiscrim}},\code{\link{StepDiscrimV}})}

\item{grps}{labeled vector that classify the observations.}

\item{method}{Selected method for discrimination. Valid options
"linear" "quadratic"}

\item{k}{the number of folds in KFCV. Must be a positive integer and lower or
equal than the number of observations}

\item{returnClassification}{Allows to select if the raw result classification
is returned.}

\item{...}{Additional arguments}
}
\value{
\itemize{
\item if returnClassification is false return a object of class
confusionMatrix
\item if returnClassification is true, it returns a list containing an
object of the confusionMatrix class and a vector with the
classification result.
}
}
\description{
Performs k-fold cross-validation where groups are chosen randomly.
In case the value k is not divisor of the number of observations the last
group will have nobs mod k observations.
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
MWA <- MultiWaveAnalysis(ECGExample, "haar", features = c("var"))
MWADiscrim <- StepDiscrim(MWA, c(rep(1, 5), rep(2, 5)), 5,
              features = c("var"))
CM <- KFCV(MWADiscrim, c(rep(1, 5), rep(2, 5)), "linear", 5,
  returnClassification = FALSE
)
}

}
