% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subspace.R
\name{subspace}
\alias{subspace}
\title{The distance between two subspaces.}
\usage{
subspace(A, B)
}
\arguments{
\item{A}{A \eqn{p}-by-\eqn{u} matrix.}

\item{B}{A \eqn{p}-by-\eqn{u} matrix.}
}
\value{
Returns a distance metric that is between 0 and 1
}
\description{
This function calculates the distance between the two subspaces with equal dimensions \eqn{\mathrm{span}(\mathbf{A})} and \eqn{\mathrm{span}(\mathbf{B})}, where \eqn{\mathbf{A}\in R^{p\times u}} and \eqn{\mathbf{B} \in R^{p\times u}} are the basis matrices of two subspaces. The distance is defined as
\deqn{\|\mathbf{P}_{\mathbf{A}} - \mathbf{P}_{\mathbf{B}}\|_F/(2d),}
where \eqn{\mathbf{P(\cdot)}} is the projection matrix onto the given subspace with the standard inner product, and \eqn{d} is the common dimension.
}
