% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TRES-package.R
\docType{package}
\name{TRES-package}
\alias{TRES-package}
\alias{TRES}
\title{Tensor Regression with Envelope Structure and Three Generic Envelope Estimation Approaches}
\description{
Provides three estimators for tensor response regression (TRR) and tensor predictor regression (TPR) models with tensor envelope structure. The three types of estimation approaches are generic and can be applied to any envelope estimation problems. The full Grassmannian (FG) optimization is often associated with likelihood-based estimation but requires heavy computation and good initialization; the one-directional optimization approaches (1D and ECD algorithms) are faster, stable and does not require carefully chosen initial values; the SIMPLS-type is motivated by the partial least squares regression and is computationally the least expensive.
}
\examples{
library(TRES)
## Load data "bat"
data("bat")
x <- bat$x
y <- bat$y
fit <- TRR.fit(x, y, method="standard")

## Print cofficient
coef(fit)

## Print the summary
summary(fit)

## Make the prediction on the original dataset
predict(fit, x)

## Draw the plot of two-way coefficient tensor (i.e., matrix)
plot(fit)

}
\references{
Cook RD, Zhang X (2016). “Algorithms for Envelope Estimation.” Journal of Computational and Graphical Statistics, 25(1), 284–300. doi:10.1080/10618600.2015.1029577.

  Li L, Zhang X (2017). “Parsimonious Tensor Response Regression.” Journal of the American Statistical Association, 112(519), 1131–1146.

Zhang X, Li L (2017). “Tensor Envelope Partial Least Squares Regression.” Technometrics, 59(4), 426–436.


Cook RD, Zhang X (2018). “Fast Envelope Algorithms.” Statistica Sinica, 28(3), 1179–1197.
}
\seealso{
Useful links:
\itemize{
 \item \url{https://github.com/jerryfsu3333/TRES}
 \item Report bugs at \url{https://github.com/jerryfsu3333/TRES/issues}
}
}
\author{
Wenjing Wang, Jing Zeng and Xin Zhang
}
