% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{predict_diagram_ksvm}
\alias{predict_diagram_ksvm}
\title{Predict the outcome labels for a list of persistence diagrams using a pre-trained diagram ksvm model.}
\usage{
predict_diagram_ksvm(
  new_diagrams,
  model,
  num_workers = parallelly::availableCores(omit = 1)
)
}
\arguments{
\item{new_diagrams}{a list of persistence diagrams which are either the output of a persistent homology calculation like \code{\link[TDA]{ripsDiag}}/\code{\link[TDAstats]{calculate_homology}}/\code{\link{PyH}}, or \code{\link{diagram_to_df}}.}

\item{model}{the output of a \code{\link{diagram_ksvm}} function call.}

\item{num_workers}{the number of cores used for parallel computation, default is one less than the number of cores on the machine.}
}
\value{
a vector containing the output of \code{\link[kernlab]{predict.ksvm}} on the cross Gram matrix of the new diagrams and the support vector diagrams stored in the model.
}
\description{
Returns the predicted response vector of the model on the new diagrams.
}
\details{
This function is a wrapper of the kernlab \code{\link{predict}} function.
}
\examples{

if(require("TDA") & require("TDAstats"))
{
  # create four diagrams
  D1 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  D2 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  D3 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  D4 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  g <- list(D1,D2,D3,D4)

  # create response vector
  y <- as.factor(c("circle","sphere","circle","sphere"))

  # fit model without cross validation
  model_svm <- diagram_ksvm(diagrams = g,cv = 1,dim = c(0),
                            y = y,sigma = c(1),t = c(1),
                            num_workers = 2)

  # create two new diagrams
  D5 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  D6 <- TDAstats::calculate_homology(TDA::circleUnif(n = 10,r = 1),
                                     dim = 0,threshold = 2)
  g_new <- list(D5,D6)

  # predict
  predict_diagram_ksvm(new_diagrams = g_new,model = model_svm,num_workers = 2)
}
}
\seealso{
\code{\link{diagram_ksvm}} for training a SVM model on a training set of persistence diagrams.
}
\author{
Shael Brown - \email{shaelebrown@gmail.com}
}
