% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf.unzip.R
\name{taf.unzip}
\alias{taf.unzip}
\title{Unzip File}
\usage{
taf.unzip(zipfile, files = NULL, exdir = ".", unzip = NULL, ...)
}
\arguments{
\item{zipfile}{zip archive filename.}

\item{files}{files to extract, default is all files.}

\item{exdir}{directory to extract to, will be created if necessary.}

\item{unzip}{extraction method to use, see details below.}

\item{\dots}{passed to \code{\link{unzip}}.}
}
\value{
No return value, called for side effects.
}
\description{
Extract files from a zip archive, retaining executable file permissions.
}
\details{
The default method \code{unzip = NULL} uses the external \command{unzip}
program in Unix-compatible operating systems, but an internal method in
Windows. For additional information, see the \code{\link{unzip}} help page.
}
\note{
One shortcoming of the base \code{unzip} function is that the default
\code{"internal"} method resets file permissions, so Linux and macOS
executables will return a \verb{'Permission denied'} error when run.

This function is identical to the base \code{unzip} function, except the
default value \code{unzip = NULL} chooses an appropriate extraction method in
all operating systems, making it useful when writing platform-independent
scripts.
}
\examples{
\dontrun{
exefile <- if(os.unix()) "run" else "run.exe"
taf.unzip("bootstrap/software/archive.zip", files=exefile, exdir="model")
}
}
\seealso{
\code{\link{unzip}} is the base function to unzip files.

\code{\link{TAF-package}} gives an overview of the package.
}
