% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANCOVA_contrast.R
\name{ANCOVA_contrast}
\alias{ANCOVA_contrast}
\title{Power Calculations for ANCOVA Contrasts}
\usage{
ANCOVA_contrast(
  cmat,
  mu,
  n = NULL,
  sd,
  r2 = NULL,
  n_cov,
  alpha_level = Superpower_options("alpha_level"),
  beta_level = NULL,
  round_up = TRUE
)
}
\arguments{
\item{cmat}{Matrix of the specific contrasts of interest}

\item{mu}{Vector specifying mean for each condition}

\item{n}{Sample size in each condition}

\item{sd}{Standard deviation for all conditions (or a vector specifying the sd for each condition)}

\item{r2}{Coefficient of Determination of the model with only the covariates}

\item{n_cov}{Number of covariates}

\item{alpha_level}{Alpha level used to determine statistical significance}

\item{beta_level}{Type II error probability (power/100-1)}

\item{round_up}{Logical indicator (default = TRUE) for whether to round up sample size calculations to nearest whole number}
}
\value{
Object of class "power.htest", a list of the arguments (including the computed one) augmented with method and note elements.
}
\description{
Complete power analyses for specific ANCOVA contrasts. This function does not support within subjects factors.
}
\section{References}{

Shieh, G. (2020). Power analysis and sample size planning in ANCOVA designs. Psychometrika, 85(1), 101-120.
}

\examples{
ANCOVA_contrast(cmat = c(-1,1),
n = 15,
mu = c(0,1),
sd = 1,
r2 = .2,
n_cov = 1)
}
