% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-radial-plot-function.r
\name{plot_radial}
\alias{plot_radial}
\title{Radial (Galbraith) plot for subgroup effect size}
\usage{
plot_radial(dat, covari.sel, trt.sel, resp.sel, outcome.type, range.v = NULL,
  adj.ann.subgrp = 4, font.size = c(1, 1, 0.85, 0.85, 1), title = NULL,
  lab.xy = NULL)
}
\arguments{
\item{dat}{a data set}

\item{covari.sel}{a vector of indices of the two covariates}

\item{trt.sel}{a covariate index specifying the treatment code}

\item{resp.sel}{a covariate index specifying the response variable}

\item{outcome.type}{a string specifying the type of the response variable, it can be "continuous", or "binary" or  "survival".}

\item{range.v}{a vector specifying the vertical range of graphical display.}

\item{adj.ann.subgrp}{a parameter adjusting the distance between a point and its corresponding subgroup label. The smaller the value
is, the larger the distance is.}

\item{font.size}{a vector specifying the size of labels and text; the first element is for the main title, the second is for
for x-axis and y-axis labels; the thrid is for the legend text of subgroups; the fourth is for the subgroup
labels near points; the fifth is for the unit labels on all the axes.}

\item{title}{a string specifying the main title.}

\item{lab.xy}{a list of two strings specifying the labels of the x and y axes.}
}
\description{
This function produces a modified Galbraith's radial plot showing the
treatment effect size of subgroups defined by the categories
of covariates. The x-axis represents the reciprocal of the standard error
 of subgroup treatment effect estimates.The y-axis means
standardized effect size difference (the difference between subgroup effect
the full popultion effect is divided by the standard error
of the estimator for the overall population effect.
Points here are for subgroups.
The grey region indicates whether subgroup effects
are homogeneous to the full population effect or not. The two arcs on the
right side show subgroup treatment effects in the original
scale, where the red spots are the projection of points from the origin on
the left side. Note that the vertical range of display can
be changed by setting different values on the associated input argument.
In addition, the function uses log odd ratio and log hazard
ratio for displaying subgroup effect sizes in binary and survival data,
respectively.
}
\examples{
library(dplyr)

# Load the data to be used
data(prca)
dat <- prca
dat \%>\%
  mutate(bm = factor(ifelse(bm == 0 , "No", "Yes")),
         hx = factor(ifelse(hx == 0 , "No", "Yes")))-> dat

label.xy = list(expression(1/hat(sigma)[hat(delta)[i]]),
                expression((hat(delta)[i]-hat(delta)[F])/hat(sigma)[hat(delta)[i]]))
plot_radial(dat,
            covari.sel = c(4, 5, 6, 7),
            trt.sel = 3,
            resp.sel = c(1, 2),
            outcome.type = "survival",
            range.v = c(-7, 6),
            adj.ann.subgrp = 4,
            font.size = c(1, 1, 0.75, 0.8, 0.85),
            lab.xy = label.xy)
}

