% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/octapos.R
\name{octapos}
\alias{octapos}
\title{Identify points in a polygon in reference to an octagon}
\usage{
octapos(x, y, i = "I1", pos = 1:8)
}
\arguments{
\item{x, y}{the coordinates of the polygons}

\item{i}{the identification of the polygons if there are multiple ones}

\item{pos}{which reference points to compute}
}
\value{
a data frame with as much columns as positions, labelled from pos1 to
pos8, or a vector if only one position is required
}
\description{
Identify points in a polygon as if they were constituting a
reference octagon, having two sides horizontal and two sides vertical: there
are eight points, starting from the right side of the upper horizontal side,
and following each other in a clockwise order.
}
\examples{
# Define polygons (in this case, two octagons) ----

dt1 <- c(0,0,0.33,0.67,1,1,0.67,0.33) - 0.5
xy1 <- c(0.33,0.67,1,1,0.67,0.33,0,0) - 0.5

dt2 <- rev(0.5 * (c(0,0,0.33,0.67,1,1,0.67,0.33) - 0.5))
xy2 <- rev(0.5 * (c(0.33,0.67,1,1,0.67,0.33,0,0) -0.5))

dt <- c(dt1, dt2)
xy <- c(xy1, xy2)
gr <- rep(c("B2","A3"), each = 8)

# Compute the position to the octagon reference ----

octa <- octapos(x = xy, y = dt, i = gr)

# Plot base----

plot.new()
plot.window(xlim = c(-0.5,0.5), ylim = c(-0.5,0.5))
axis(1)
axis(2, las = 1)
title(xlab = "x", ylab = "y")
polygon(x = xy1, y = dt1)
points(x = xy1, y = dt1, pch = 19)
polygon(x = xy2, y = dt2)
points(x = xy2, y = dt2, pch = 19)

# Plot the positions ----

one <- rep(NA, nrow(octa))

one[octa$pos1] <- 1
one[octa$pos2] <- 2
one[octa$pos3] <- 3
one[octa$pos4] <- 4
one[octa$pos5] <- 5
one[octa$pos6] <- 6
one[octa$pos7] <- 7
one[octa$pos8] <- 8

text(0.8 * xy, 0.8 * dt, one)

}
