% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.joint.R
\name{is.joint}
\alias{is.joint}
\title{Check (bedding) joint objects}
\usage{
is.joint(joint, warn = F)
}
\arguments{
\item{joint}{the data.frame to test}

\item{warn}{whether to have a warning explaining why the candidate joint
is invalid}
}
\description{
Check whether a data.frame complies with the criteria to be a
valid bedding joint to be integrated in a litholog.
}
\examples{
# Plots for visualisation ----

opar <- par("mfrow")
par(mfrow = c(2,1))

plot.new()
plot.window(xlim = range(oufti99$'1sin'$x),
            ylim = range(oufti99$'1sin'$y))
title("oufti99$'1sin'")
placesvg(oufti99$'1sin')

plot.new()
plot.window(xlim = range(oufti99$ammonite$x),
            ylim = range(oufti99$ammonite$y), asp = 1)
title("oufti99$ammonite")
placesvg(oufti99$ammonite)

par(mfrow = opar)

# Exemplification of is.joint ----

is.joint(oufti99$'1sin')

is.joint(oufti99$ammonite)

}
