% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/earpoints.R
\name{earpoints}
\alias{earpoints}
\title{Draws points on an equal area stereonet}
\usage{
earpoints(
  dec,
  inc,
  hsphere = "b",
  double = FALSE,
  a = list(pch = 21, col = "black"),
  l = list(bg = "black"),
  h = list(bg = "grey"),
  u = list(bg = "white"),
  labels = NA,
  pos = 4,
  output = FALSE,
  plot = TRUE,
  xh = "WE"
)
}
\arguments{
\item{dec}{declination of the data; it is the angle from the north
taken on an horizontal plane. It is measured clockwise from North and ranges
from 0 to 360° (Tauxe 2010). Values outside this range are corrected by the
\code{\link{incfix}} function.}

\item{inc}{inclination of the data; it is the angle from the
horizontal, is positive downward, and ranges from +90° for straight down to
-90° for straight up (Tauxe, 2010). Values outside this range are corrected
by the \code{\link{incfix}} function.}

\item{hsphere}{the hemisphere onto which to project the data. The
default is "b" for both: this useful in the case of oriented vectors rather
than lines like for paleomagnetism. Other choices are "l" and "u" for lower
and upper hemisphere.}

\item{double}{whether to plot the equivalent point to one having an
inclination of 0°(with dec = dec +180)}

\item{a, l, h, u}{list of graphical parameters to feed points() for all
points, or for the points of the upper (u) and lower (l) hemisphere, and of
the samples having an inclination of 0° (h) (the three latter override a).
See ?points help page for the possible arguments. See the example for
illustration, and ?merge_list for further information.}

\item{labels}{labels to each point}

\item{pos}{position of each label (see text() help page)}

\item{output}{whether to return an output (position of the points in
the stereographic projection)}

\item{plot}{whether to plot}

\item{xh}{orientation of the x axis: can be 'WE' or 'SN'.}
}
\value{
the x,y coordinates of each point in the projection
}
\description{
Draws points on an equal area stereonet (modified from RFOC
package)
}
\examples{
earnet()

h <- 17
m <- 11

if(m < 10) a <- "0" else a <- ""

title(paste("Il est ", h, "h",a,m, sep = ""))

i1 <- seq(40, 100, by = 10)
i2 <- seq(0, -100, by = -10)
d1 <- rep(h * 30 + m * 0.5, length(i1))
d2 <- rep(m*6, length(i2))

inc <- c(i1,i2)
dec <- c(d1,d2)

earpoints(dec,inc)

}
\references{
Snyder, John P., 1987, Map Projections-a working manual,
USGS-Professional Paper, 383p. pages 185-186, RFOC package
}
\seealso{
\code{\link{earnet}}, \code{\link{earplanes}} and
\code{\link{incfix}}
}
