% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmean.R
\name{fmean}
\alias{fmean}
\title{Fischer mean}
\usage{
fmean(dec = NA, inc = NA, int = 1, x = NA, y = NA, z = NA, id = NULL, cart = F)
}
\arguments{
\item{dec}{declination of the data; it is the angle from the north
taken on an horizontal plane. It is measured clockwise from North and ranges
from 0 to 360° (Tauxe 2010). Values outside this range are corrected by
incfix().}

\item{inc}{inclination of the data; it is the angle from the
horizontal, is positive downward, and ranges from +90° for straight down to
-90° for straight up (Tauxe, 2010). Values outside this range are corrected
by incfix().}

\item{int}{intensity of the data. Defaults to one (unit sphere).}

\item{x, y, z}{cartesian coordinates. x is the North, y the East, and z
straight down. If dec and inc are not provided they are used to be converted
back in dec, inc and int data. Output is corrected by incfix().}

\item{id}{a name for each point, identifying each group of points you would
like to treat separately}

\item{cart}{whether to output as cartesian coordinates, defaults to F}
}
\value{
a list of coordinates for the fischer mean, in cartesian form or dec,
inc, int form
}
\description{
Fischer mean
}
\examples{
dec <- c(rnorm(10, mean = 45, sd = 5), rnorm(10, mean = 20, sd = 5))
inc <- c(rnorm(10, mean = 45, sd = 5), rnorm(10, mean = 20, sd = 5))
id  <- c(rep(1, 10), rep(2, 10))

earnet()
earpoints(dec, inc)

fm <- fmean(dec, inc, id = id)

earpoints(fm $dec, fm$inc, l = list(bg = "red"))

}
\seealso{
\code{\link{fmod}}, \code{\link{dipfix}} and \code{\link{incfix}}
}
