% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfDisplay.R
\name{pdfDisplay}
\alias{pdfDisplay}
\title{Generates PDF and SVG figures}
\usage{
pdfDisplay(
  g,
  name,
  ext = ".pdf",
  dir = tempdir(),
  width = 10,
  height = 10,
  parg = list(),
  track = T,
  openfile = T,
  output = F,
  warn = F
)
}
\arguments{
\item{g}{the plot function to be exported and looked at}

\item{name}{the name of the document}

\item{ext}{the extension of the document: ".pdf" by default, but
".svg" works also.}

\item{dir}{the file where the document will be saved (by default a temporary
directory, tempdir())}

\item{width}{the width of the drawing area (in inches)}

\item{height}{the height of the drawing area (in inches)}

\item{parg}{list of arguments transmitted to the par() function}

\item{track}{whether to generate different files for each rerun of pdfDisplay
with identical 'name'. The name will be followed by '_(i)' where i is the
version number. With this you avoid closing your pdf file at each rerun if
your pdf reader is not able to deal with (to my knowledge only SumatraPDF is
able)}

\item{openfile}{should the pdf file be opened (for the moment works
only in Windows). Use SumatraPDF as default pdf reader to be able to write
over current file}

\item{output}{whether to output the output of g() or not}

\item{warn}{useless vestigial parameter, kept for compatibility with
StratigrapheR 0.0.1}
}
\value{
the output of the g() function if output = TRUE
}
\description{
Takes an ensemble of figures, represented by a function g(), and
generates a PDF (or SVG if specified). The PDF can be visualised immediatly
on the default PDF reader.
}
\details{
The width and height you provide will not exactly be respected.
I could not find a pdf printing function that respects dimensions
scrupulously for R base graphics.
}
\examples{
\donttest{temp <- tempfile()
dir.create(temp)

g1   <- function() plot(1,1)

pdfDisplay(g1(),"TestGraph", dir = temp,
           parg = list(mar = c(6,6,6,6), ps = 24,lwd = 4))

g1   <- function() plot(1,1, col = "red")

pdfDisplay(g1(), "TestGraph", dir = temp,
           parg = list(mar = c(6,6,6,6), ps = 24,lwd = 4))}

}
