% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neatPicked.R
\name{neatPicked}
\alias{neatPicked}
\title{Runs neatPick without user input}
\usage{
neatPicked(
  fun,
  n,
  args = NA,
  width = 10,
  height = 10,
  output = "all",
  name = "Fig",
  dir = tempdir(),
  gfile = "onePDF",
  openfile = TRUE,
  track = TRUE,
  folder = "My file",
  gfun = "jpeg",
  ext = ".jpeg",
  gargs = list(units = "in", res = 300),
  pargs = list()
)
}
\arguments{
\item{fun}{the function to be applied n times.}

\item{n}{number of runs.}

\item{args}{the arguments to be supplied to fun. Should be a list of
each argument to be supplied to fun, having n elements stored
indiscriminately in list or in vector form.}

\item{width, height}{the width and height of the graphics region. In
inches by default, can be adapted if onePDFfile = FALSE}

\item{output}{the kind of output : "function" for the accumulated
outputs of the function (list of n elements), "all" to add args, and
everything else to output nothing}

\item{name}{the names of the graphic file(s)}

\item{dir}{the directory of the file or of the folder of files, by default a
temporary file}

\item{gfile}{whether to create a single pdf with n pages
("onePDF"; default) or a folder of n graphical files ("gfun"). If anything
else is given ("none for instance"), it won't produce graphical files. This
reduces computation speed by a little more than 15 percents (one try of 1000
samples with simple graphs).}

\item{openfile, track}{parameters for pdfDisplay()}

\item{folder}{the name of the folder containing the n graphical files}

\item{gfun}{a non-empty character string naming the graphical
function to be called to create the n graphical files}

\item{ext}{the extension of the n graphical files}

\item{gargs}{list of arguments transmitted to the graphical function}

\item{pargs}{list of arguments transmitted to the par() function}
}
\value{
the accumulated outputs of fun (and arguments if asked) if asked
}
\description{
Is the user input free version of neatPick. Runs a function n
times, with its arguments n times different. The graphical output is stored
into a n pages pdf or a n files folder. The output of the function is
accumulated in a list.
}
\examples{
\donttest{fun <- function(x, y, xlim = c(-1,1),...)
{
  plot(x, y, xlim = xlim,...)

  return(paste(x, y, paste(xlim, collapse = "; "), sep = "; "))
}

args <- list(x = list(-0.5, 1) , y = c(0.8, 0.8), pch = c(2,4),
             xlim = list(c(-1,1), c(-20,20)))

temp <- tempfile()
dir.create(temp)

neatPicked(fun, 2, args = args, width = 5, height = 5, dir = temp)}

}
