% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sys_deville.R
\name{sys_devillepi2}
\alias{sys_devillepi2}
\title{Second order inclusion probabilities of Deville's systematic}
\usage{
sys_devillepi2(pik)
}
\arguments{
\item{pik}{A vector of inclusion probabilities}
}
\value{
A matrix of second order inclusion probabilities.
}
\description{
This function returns the second order inclusion probabilities of Deville's systematic.
}
\examples{
set.seed(1)
N <- 30
n <- 4
pik <- as.vector(inclprob(runif(N),n))
PI <- sys_devillepi2(pik)
#image(as(as.matrix(PI),"sparseMatrix"))

pik <- c(0.2,0.5,0.3,0.4,0.9,0.8,0.5,0.4)
PI <- sys_devillepi2(pik)
#image(as(as.matrix(PI),"sparseMatrix"))
}
\references{
Deville, J.-C. (1998), Une nouvelle méthode de tirage à probabilité inégales. Technical Report 9804, Ensai, France.

 Chauvet, G. (2012), On a characterization of ordered pivotal sampling, Bernoulli, 18(4):1320-1340
}
