% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_ranger.R
\name{predict.ple_ranger}
\alias{predict.ple_ranger}
\title{Predict Patient-level Estimates: Ranger}
\usage{
\method{predict}{ple_ranger}(object, newdata = NULL, oob = FALSE, ...)
}
\arguments{
\item{object}{Trained random forest (ranger) model(s).}

\item{newdata}{Data-set to make predictions at (Default=NULL, predictions correspond
to training data).}

\item{oob}{Use out-of-bag predictions (default=TRUE). Only applicable for training data
(newdata=NULL).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Data-frame with predictions of (E(Y|X,A=1), E(Y|X,A=0), E(Y|X,A=1)-E(Y|X,A=0)) or
survival probabilities and difference in restricted mean survival time (RMST),
(S(T|X,A=1), S(T|X,A=0), RMST(A=1,X)-RMST(A=0,X) )
}
\description{
Get estimates of (E(Y|X,A=1), E(Y|X,A=0), E(Y|X,A=1)-E(Y|X,A=0)) using trained random
forest (ranger) model(s).
}
\examples{
\donttest{
library(StratifiedMedicine)
## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A


# Default (treatment-specific ranger models) #
mod1 = ple_ranger(Y, A, X, Xtest=X)
summary( predict(mod1 ) ) # oob predictions for training
summary( predict(mod1, newdata=X ) ) # new-predictions, no oob here
}

}
