% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRISM.R
\name{predict.PRISM}
\alias{predict.PRISM}
\title{PRISM: Patient Response Identifier for Stratified Medicine (Predictions)}
\usage{
\method{predict}{PRISM}(object, newdata = NULL, type = "all", ...)
}
\arguments{
\item{object}{Trained PRISM model.}

\item{newdata}{Data-set to make predictions at (Default=NULL, predictions correspond
to training data).}

\item{type}{Type of prediction. Default is "all" (ple, submod, and param predictions).
Other options include "ple" (ple predictions), "submod" (submod predictions with
associated parameter estimates).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Data-frame with predictions (ple, submod, or both).
}
\description{
Predictions for PRISM algorithm. Given the training set (Y,A,X) or new test set (Xtest),
output ple predictions and identified subgroups with correspond parameter estimates.
}
\examples{
## Load library ##
library(StratifiedMedicine)

##### Examples: Continuous Outcome ###########

dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

# Run Default: filter_glmnet, ple_ranger, submod_lmtree, param_ple #
res0 = PRISM(Y=Y, A=A, X=X)
summary( predict(res0) ) # all #
summary( predict(res0, type="ple") )
summary( predict(res0, type="submod") )


}
