% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_glmnet.R
\name{ple_glmnet}
\alias{ple_glmnet}
\title{Patient-level Estimates: Elastic Net (glmnet)}
\usage{
ple_glmnet(Y, A, X, Xtest, lambda = "lambda.min", family, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric or survival (ex; Surv(time,cens) )}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{Xtest}{Test set}

\item{lambda}{Lambda for elastic-net (default = "lambda.min"). Other options include
"lambda.1se" or  fixed values}

\item{family}{Outcome type ("gaussian", "binomial", "survival"), default is "gaussian"}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Trained glmnet model(s).
 \itemize{
  \item mods - trained model(s)
  \item lambda - Lambda used for elastic-net (passes to prediction function)
  \item X - Covariate Space (in model matrix form)
}
}
\description{
Uses the elastic net (glmnet R package) to obtain patient-level estimates. Usable for
continuous, binary, or survival outcomes.
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

mod1 = ple_glmnet(Y, A, X, Xtest=X, family="gaussian")
summary(mod1$mu_train$PLE)

}
