% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-BACKTEST.R
\docType{methods}
\name{backtest}
\alias{backtest}
\alias{backtest,Strategy-method}
\title{Backtest Strategy}
\usage{
backtest(object, horizon = "6m", data.width = "24m", keep.history = F,
  optim.param = NULL, optim.param.min = 1, optim.param.max = 10,
  optim.param.scale = 0.1, from = NULL, until = NULL, which = NULL,
  rf = 0, printSteps = F)

\S4method{backtest}{Strategy}(object, horizon = "6m", data.width = "24m",
  keep.history = F, optim.param = NULL, optim.param.min = 1,
  optim.param.max = 10, optim.param.scale = 0.1, from = NULL,
  until = NULL, which = NULL, rf = 0, printSteps = F)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{horizon}{The out-of-sample period length.}

\item{data.width}{The in-sample period length used for calibration.}

\item{keep.history}{If set to \code{TRUE}, the starting point of in-sample data is kept fixed, so the period extends each iteration.}

\item{optim.param}{A character vector providing the names of the parameters to be calibrated. Parameters that are not provided will be kept fix.}

\item{optim.param.min}{A numeric vector providing the minimum values of the parameters that are calibrated.}

\item{optim.param.max}{A numeric vector providing the maximum values of the parameters that are calibrated.}

\item{optim.param.scale}{A numeric vector providing the scaling of the parameters that are calibrated. It is adviseable to set scaling of the parameters to the smallest unit that makes sense.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which assets shall be considered. If \code{NULL}, no restriction is made.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which assets shall be considered. If \code{NULL}, no restriction is made.}

\item{which}{Names or number of assets that should be included in backtest}

\item{rf}{Risk free rate in decimal, e.g. \code{rf=0.01} equals \code{1 percent}.}

\item{printSteps}{This is a feature used mainly for debugging the constructor function in order to localize where unspecified errors occur. If set to true, the different steps run within the constructor is printed to the console.}
}
\description{
Walk forward analysis backtest with the specified parameters on an object of class \code{Strategy}. The backtest calibrates the parameters according to the specification given by the user (in-sample) and returns the trading signals for the following period (out-of-sample). This is iteratively repeated on a shifting time window. Computer performance is critical with this function.
}
\examples{
##Not run:
# MA(200)-Strategy
params <- list(k=20)
# reduce dataset due to computation time
assets_r <- assets[tail(index(assets),100)]
myStrat.MA <- Strategy(assets=assets_r, strat="MA", strat.params=params)

# Perform backtest on MA(20)-Strategy with
# out-of-sample periods of 2 months
# and in-sample-calibration of 2 months
# This example requires a lot of computation time,
# so this is only performed for 1 asset and high scaling.
backtest(myStrat.MA, horizon="2m", data.width="2m"
         , optim.param="k", optim.param.min=5, optim.param.max=10
         , optim.param.scale=5, printSteps = TRUE, which=1)
##End(Not run)
}

