% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_usms_files.R
\name{get_usms_files}
\alias{get_usms_files}
\title{Getting existing xml files path list per usm from an usms.xml file}
\usage{
get_usms_files(
  workspace,
  usms_list = NULL,
  usms_file = "usms.xml",
  file_type = NULL,
  javastics = NULL,
  workspace_path = lifecycle::deprecated(),
  file_name = lifecycle::deprecated(),
  javastics_path = lifecycle::deprecated()
)
}
\arguments{
\item{workspace}{Path of a JavaSTICS workspace (i.e. containing the STICS
XML input files)}

\item{usms_list}{Vector of usms names (Optional)}

\item{usms_file}{Path (including name) of a USM XML file.}

\item{file_type}{Vector of file(s) type to get (if not given,
all types are returned, see details)}

\item{javastics}{Path of JavaSTICS Optional, only needed if the plant files
are not in the workspace
(in this case the plant files used are those included in the
JavaSTICS distribution)}

\item{workspace_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{workspace_path}
is no longer supported, use \code{workspace} instead.}

\item{file_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{file_name} is no
longer supported, use \code{usms_file} instead.}

\item{javastics_path}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{javastics_path}
is no longer supported, use \code{javastics} instead.}
}
\value{
A named list with existing files path in each usm element
}
\description{
Getting existing xml files path list per usm from an usms.xml file
}
\details{
The possible values of file types are: "fplt", "finit", "fclim1",
"fclim2", "fstation" and "ftec"
}
\examples{
\dontrun{

get_usms_files(
  workspace = "/path/to/workspace",
  javastics = "/path/to/JavaSTICS/folder"
)

get_usms_files(
  workspace = "/path/to/workspace",
  javastics = "/path/to/JavaSTICS/folder", usm_list = c("usm1", "usm3")
)

get_usms_files(
  workspace = "/path/to/workspace",
  file_type = c("finit", "ftec")
)
}

}
\seealso{
See \code{get_soils_list()} to get all soils in a usm file,
and \code{get_usms_list()} to get the list of usms.
}
