% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection_functions.R
\name{sim.data.from.priors.for.mod.selection}
\alias{sim.data.from.priors.for.mod.selection}
\title{Simulate data from priors for doing model selection}
\usage{
sim.data.from.priors.for.mod.selection(n.muts, coes.prior, sigs.prior,
  mods.to.sim, d.true, d.range, d.adj.max, w.wt, wts, outpath, n.samps.per.mod,
  coe.sim.model = "identical", coe.dist.par = NA, print.interval = NA)
}
\arguments{
\item{n.muts}{Number of mutations to simulate. Vector of the form \code{c(3,4,5)}.}

\item{coes.prior}{A vector with the lower and upper bounds on the coefficients}

\item{sigs.prior}{Range for uniform prior on sigma}

\item{mods.to.sim}{Models to simulate under. Vector with model names of the form c("stick", "mult", "add").}

\item{d.true}{True value of d.}

\item{d.range}{Range of possible values for d. If estimate is outside this, estimate is not considered valid.}

\item{d.adj.max}{Factor to increase observed distant to max fitness by for ad hoc d estimate (when other estimators fail)}

\item{w.wt}{Wild type fitness.}

\item{wts}{Weights when estimating coefficients and d.}

\item{outpath}{Full path including file name to write results.}

\item{n.samps.per.mod}{Number of datasets to simulate per model}

\item{coe.sim.model}{Coefficient simulation model. See details.}

\item{coe.dist.par}{Coefficient distribution parameter. If coe.sim.model=="uniform", then uniform is U(-coe.dist.par, +coe.dist.parm).
If coe.sim.model=="normal", then distributed normal with mean given by coe.v and sigma give by coe.dist.parm.}

\item{print.interval}{Every this many replicates, prints out replicate number. If NA (default) no printing is done.}
}
\value{
Nothing. Instead results are written to \code{outpath} file for later analysis
}
\description{
Simulate data from priors for doing model selection
}
\details{
This function generates datasets by drawing from priors. It generates \code{n.samps.per.mod}
per model. It then analyzes each dataset under all three models writes one row of summary statistics
to the output file (defined by \code{outpath}).
\code{coe.sim.model}: The expected coefficient is sampled from uniform prior (coes.prior): E[coe]
The coe.sim.model determines how the individual coefficients are generated.
 Possible values: "identical" means all coefficients take same value--E[coe].
"uniform" indicates to  sample individual coefficients from a uniform distribution: U(E[coe]-coe.dist.par, E[coe]+coe.dist.parm).
"normal" means sample coefficients from normal distribution with mean E[coe] and sigma given by coe.dist.par.
Default = "identical".
}
\examples{
 n.muts <- 4
 n.muts <- length(Khan.data[1,])-1
 geno.matrix <- Khan.data[,seq(1, n.muts)]
 fit.matrix <- as.matrix(Khan.data[,(n.muts+1)])
 outdir <- system.file("extdata",package="Stickbreaker")
 file.name <- paste("Training_simulated_priors_fit_data_", n.muts, "muts.txt", sep="")
 outpath <- paste(outdir, file.name, sep="/")
 sim.data.from.priors.for.mod.selection(n.muts,
   c(0.05, 0.5),
   c(0, 0.25),
   c(4),
   1,
   c(0.1, 10),
   1.1,
   1,
   c(2,1),
   outpath,
   50,
   coe.sim.model="identical",
   coe.dist.par=NA,
   print.interval=NA)
}

