% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ElasticNet_HJBiplot.R
\name{ElasticNet_HJBiplot}
\alias{ElasticNet_HJBiplot}
\title{Elastic Net HJ Biplot}
\usage{
ElasticNet_HJBiplot(X, lambda = 1e-04, alpha = 1e-04, transform_data = 'scale',
    ind_name = FALSE, vec_name = TRUE)
}
\arguments{
\item{X}{array_like; \cr
A data frame with the information to be analyzed}

\item{lambda}{float; \cr
Tuning parameter of the LASSO penalty. Higher values lead to sparser components.}

\item{alpha}{float; \cr
Tuning parameter of the Ridge shrinkage}

\item{transform_data}{character; \cr
A value indicating whether the columns of X (variables) should be centered or scaled. Options are: "center" or "scale". For default is "scale".}

\item{ind_name}{bool; \cr
Logical value, if it is TRUE it prints the name for each row of X. If it is FALSE (default) does not print the names.}

\item{vec_name}{bool; \cr
Logical value, if it is TRUE (default) it prints the name for each column of X. If it is FALSE does not print the names.}
}
\value{
\code{ElasticNet_HJBiplot} returns a list containing the following components:
\item{loadings}{  array_like; \cr
          penalized loadings, the loadings of the sparse principal components.
          }

\item{n_ceros}{  array_like; \cr
          number of loadings equal to cero in each component.
          }

\item{coord_ind}{  array_like; \cr
          matrix with the coordinates of individuals.
          }

\item{coord_var}{  array_like; \cr
          matrix with the coordinates of variables.
          }

\item{eigenvalues}{  array_like; \cr
          vector with the eigenvalues penalized.
          }

\item{explvar}{  array_like; \cr
          an vector containing the proportion of variance explained by the first 1, 2,.,k sparse principal components obtained.
          }
}
\description{
This function is a generalization of the Ridge regularization method and the LASSO penalty. Realizes the representation of the SPARSE HJ Biplot through a combination of LASSO and Ridge, on the data matrix. This means that with this function you can eliminate weak variables completely as with the LASSO regularization or contract them to zero as in Ridge.
}
\details{
Algorithm used to perform automatic selection of variables and continuous contraction simultaneously. With this method, the model obtained is simpler and more interpretable. It is a particularly useful method when the number of variables is much greater than the number of observations.
}
\examples{
 data(mtcars)
 ElasticNet_HJBiplot(mtcars, 0.2, 0.1, transform_data = 'scale', ind_name=TRUE)

}
\references{
\itemize{
 \item Galindo, M. P. (1986). Una alternativa de representacion simultanea: HJ-Biplot. Questiio, 10(1), 13-23.
 \item Erichson, N. B., Zheng, P., Manohar, K., Brunton, S. L., Kutz, J. N., & Aravkin, A. Y. (2018). Sparse principal component analysis via variable projection. arXiv preprint arXiv:1804.00341.
 \item Zou, H., & Hastie, T. (2005). Regularization and variable selection via the elastic net. Journal of the royal statistical society: series B (statistical methodology), 67(2), 301-320.
}
}
\author{
Mitzi Cubilla-Montilla, Carlos Torres, Ana Belen Nieto Librero and Purificacion Galindo Villardon
}
