% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog.R
\name{refreshTable}
\alias{refreshTable}
\title{Invalidates and refreshes all the cached data and metadata of the given table}
\usage{
refreshTable(tableName)
}
\arguments{
\item{tableName}{the qualified or unqualified name that designates a table. If no database
identifier is provided, it refers to a table in the current database.}
}
\description{
Invalidates and refreshes all the cached data and metadata of the given table. For performance
reasons, Spark SQL or the external data source library it uses might cache certain metadata about
a table, such as the location of blocks. When those change outside of Spark SQL, users should
call this function to invalidate the cache.
}
\details{
If this table is cached as an InMemoryRelation, drop the original cached version and make the
new version cached lazily.
}
\note{
since 2.2.0
}
\examples{
\dontrun{
sparkR.session()
refreshTable("myTable")
}
}
