#' Runs the SpNetPrep Shiny web application.
#' 
#' Spatial statistics studies have been commonly based on geographic structures made of polygons representing an administrative or political division of different order, depending on the size of the region being analyzed and on the specific interest of the researchers. More specifically, the basic spatial units in these studies have ranged from larger (countries or counties) to smaller (cities, boroughs, census tracks, etc.), allowing the employment of the usually available information regarding these kind of population units. 
#' However, last years are bringing a higher number of spatial analysis that are defined over network structures, which allow a better understanding of some spatial point patterns of great interest. Basically, the use of spatial networks has become quite frequent when the events of study actually take place in roads, streets, highways, etc., which oblige to discard most of the areal region of the zone of analysis if an accurate investigation is intended.
#' The SpNetPrep package does not deal with statistics, but with the previous steps that can be required in order to perform a spatial statistical analysis of a point pattern that lies on a linear network representing a road structure. In this regard, the name chosen for the package summarizes its main goal of "Spatial Network Preprocessing" (SpNetPrep). The main feature provided by the SpNetPrep package is an interactive application that allows to carry out the complete preprocessing of a linear network that comes from a road structure. This application launches when the user types the instruction \code{runAppSpNetPrep()} in the R console (after the installation of the package), and it is also available online in https://albriz.shinyapps.io/spnetprep/. If the application is run from the console, it is necessary to click the option "Open in browser" when it shows, or define "Run external" for the opening of Shiny applications in order to be able to download the modifications performed on the objects uploaded to it.
#' @export
runAppSpNetPrep <- function() {
  appDir <- system.file("shiny", "myapp", package = "SpNetPrep")
  if (appDir == "") {
    stop("Could not find example directory. Try re-installing SpNetPrep.", call. = FALSE)
  }
  shiny::runApp(appDir, display.mode = "normal")
}