% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsolve_GMRES.R
\name{lsolve.gmres}
\alias{lsolve.gmres}
\title{Generalized Minimal Residual method}
\usage{
lsolve.gmres(A, B, xinit = NA, reltol = 1e-05, maxiter = 1000,
  preconditioner = diag(ncol(A)), restart = (ncol(A) - 1), verbose = TRUE)
}
\arguments{
\item{A}{an \eqn{(m\times n)} dense or sparse matrix. See also \code{\link[Matrix]{sparseMatrix}}.}

\item{B}{a vector of length \eqn{m} or an \eqn{(m\times k)} matrix (dense or sparse) for solving \eqn{k} systems simultaneously.}

\item{xinit}{a length-\eqn{n} vector for initial starting point. \code{NA} to start from a random initial point near 0.}

\item{reltol}{tolerance level for stopping iterations.}

\item{maxiter}{maximum number of iterations allowed.}

\item{preconditioner}{an \eqn{(n\times n)} preconditioning matrix; default is an identity matrix.}

\item{restart}{the number of iterations before restart.}

\item{verbose}{a logical; \code{TRUE} to show progress of computation.}
}
\value{
a named list containing \describe{
\item{x}{solution; a vector of length \eqn{n} or a matrix of size \eqn{(n\times k)}.}
\item{iter}{the number of iterations required.}
\item{errors}{a vector of errors for stopping criterion.}
}
}
\description{
GMRES is a generic iterative solver for a nonsymmetric system of linear equations. As its name suggests, it approximates
the solution using Krylov vectors with minimal residuals.
}
\examples{
## Overdetermined System
A = matrix(rnorm(10*5),nrow=10)
x = rnorm(5)
b = A\%*\%x

out1 = lsolve.cg(A,b)
out3_1 = lsolve.gmres(A,b,restart=2)
out3_2 = lsolve.gmres(A,b,restart=3)
out3_3 = lsolve.gmres(A,b,restart=4)
matout = cbind(matrix(x),out1$x, out3_1$x, out3_2$x, out3_3$x);
colnames(matout) = c("true x","CG", "GMRES(2)", "GMRES(3)", "GMRES(4)")
print(matout)


}
\references{
\insertRef{saad_gmres:_1986}{SolveLS}
}
