% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_numeric_viz.R
\name{ExpNumViz}
\alias{ExpNumViz}
\title{Distributions of numeric variables}
\usage{
ExpNumViz (data,gp=NULL,type=1,nlim=NULL,fname=NULL,col=NULL,Page=NULL,sample=NULL)
}
\arguments{
\item{data}{dataframe or matrix}

\item{gp}{target variable}

\item{type}{1 (boxplot by category and overall), 2 (boxplot by category only), 3 (boxplot for overall)}

\item{nlim}{numeric variable unique limit. Default nlim is 3, graph will exclude the numeric variable which is having less than 'nlim' unique value}

\item{fname}{output file name}

\item{col}{define the fill color for box plot. Number of color should be equal to number of categories in target variable}

\item{Page}{output pattern. if Page=c(3,2), It will generate 6 plots with 3 rows and 2 columns}

\item{sample}{random selection of plots}
}
\value{
returns collated graphs in PDF or JPEG format

Scatter plot for numeric data

Density plot for numeric data

Boxplot – by overall

Boxplot – by group (target variable)

Boxplot – by overall and group (target variable)
}
\description{
This function automatically scans through each variable and creates density plot, scatter plot and box plot for continuous variable.
}
\details{
This function automatically scan each variables and generate a graph based on the user inputs. Graphical representation includes scatter plot, box plot and density plots.
If input "gp" is continuous then output is scatter plots

If input "gp" is categorical then output is box plot.

If input "gp" is NULL, means there is no target variable and this will generate density plot for all numeric features
}
\examples{
## Generate Boxplot by category
ExpNumViz(mtcars,gp="gear",type=2,nlim=25,fname = file.path(tempdir(),"Mtcars2"),Page = c(2,2))
## Generate Density plot
ExpNumViz(mtcars,gp=NULL,type=3,nlim=25,fname = file.path(tempdir(),"Mtcars3"),Page = c(2,2))
## Generate Scatter plot
ExpNumViz(mtcars,gp="carb",type=3,nlim=25,fname = file.path(tempdir(),"Mtcars4"),Page = c(2,2))
}
\seealso{
\code{\link[ggplot2:geom_boxplot]{geom_boxplot}}
}
