% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-overlap-measures.R
\name{Tau_BC}
\alias{Tau_BC}
\title{Tau-BC}
\usage{
Tau_BC(
  A_data,
  B_data,
  condition,
  outcome,
  baseline_phase = NULL,
  intervention_phase = NULL,
  improvement = "increase",
  SE = "unbiased",
  confidence = 0.95,
  trunc_const = FALSE,
  Kendall = FALSE,
  pretest_trend = FALSE,
  report_correction = FALSE,
  warn = TRUE
)
}
\arguments{
\item{A_data}{vector of numeric data for A phase. Missing values are dropped.}

\item{B_data}{vector of numeric data for B phase. Missing values are dropped.}

\item{condition}{vector identifying the treatment condition for each
observation in the series.}

\item{outcome}{vector of outcome data for the entire series.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. Defaults to first
observed value of \code{condition}.}

\item{intervention_phase}{character string specifying which value of
\code{condition} corresponds to the intervention phase. Defaults to second
unique value of \code{condition}.}

\item{improvement}{character string indicating direction of improvement.
Default is "increase".}

\item{SE}{character value indicating which formula to use for calculating the
standard error of Tau-BC, with possible values \code{"unbiased"} for the
exactly unbiased estimator, \code{"Hanley"} for the Hanley-McNeil
estimator, \code{"null"} for the (known) variance under the null hypothesis
of no effect, or \code{"none"} to not calculate a standard error. Defaults
to "unbiased". Note that the "unbiased" standard error is unbiased for
\code{\link{Tau}}, but not necessarily unbiased for \code{\link{Tau_BC}}.
None of the standard error formulas account for the additional uncertainty
due to use of the baseline trend correction.}

\item{confidence}{confidence level for the reported interval estimate. Set to
\code{NULL} to omit confidence interval calculations.}

\item{trunc_const}{logical value indicating whether to return the truncation
constant used to calculate the standard error.}

\item{Kendall}{logical value indicating whether to use Kendall's rank
correlation to calculate the Tau effect size measure. If \code{TRUE}, the
Kendall's rank correlation (with adjustment for ties) is calculated between
the data and a dummy coded phase variable, which is consistent with the
method used in Tarlow (2017). Default is \code{FALSE}, which calculates
\code{\link{Tau}} (non-overlap) index (without adjustment for ties).}

\item{pretest_trend}{significance level for the initial baseline trend test.
The raw data are corrected and \code{\link{Tau_BC}} is calculated only if
the baseline trend is statistically significant. Otherwise,
\code{\link{Tau_BC}} is equal to \code{\link{Tau}}. Default is
\code{FALSE}, which always adjusts for the baseline trend.}

\item{report_correction}{logical value indicating whether to report the
baseline corrected slope and intercept values. Default is \code{FALSE}.}

\item{warn}{logical value indicating whether to print a message regarding the
outcome of the baseline trend test. Default is \code{TRUE}.}
}
\value{
A list containing the estimate, standard error, and/or confidence
  interval.
}
\description{
Calculates the baseline-corrected Tau index (Tarlow 2017).
}
\details{
Tau-BC is an elaboration of the \code{\link{Tau}} that includes a
  correction for baseline trend. The calculation of Tau-BC involves two or
  three steps, depending on the \code{pretest_trend} argument.

  If \code{pretest_trend = FALSE} (the default), the first step involves
  adjusting the outcomes for baseline trend estimated using Theil-Sen
  regression. In the second step, the residuals from Theil-Sen regression are
  used to calculate the \code{Tau} (using either Kendall's rank correlation,
  with adjustment for ties, or computing Tau directly, without adjustment for
  ties).

  Alternately, \code{pretest_trend} can be set equal to a significance level
  between 0 and 1 (e.g. \code{pretest_trend = .05}, as suggested by Tarlow
  (2017). In this case, the first step involves a significance test for the
  slope of the baseline trend based on Kendall's rank correlation. If the
  slope is not significantly different from zero, then no baseline trend
  adjustment is made and Tau-BC is set equal to \code{Tau} index. If the
  slope is significantly different from zero, then in the second step, the
  outcomes are adjusted for baseline trend using Theil-Sen regression. Then,
  in the third step, the residuals from Theil-Sen regression are used to
  calculate the \code{Tau} index. If \code{Kendall = FALSE} (the default),
  then \code{\link{Tau}} (non-overlap) index is calculated. If \code{Kendall
  = TRUE}, then Kendall's rank correlation is calculated, including
  adjustment for ties, as in Tarlow (2017).

  Note that the standard error formulas are based on the standard errors for
  \code{\link{Tau}} (non-overlap) and they do not account for the additional
  uncertainty due to use of the baseline trend correction (nor to the
  pre-test for statistical significance of baseline trend, if used).
}
\examples{
A <- c(20, 20, 26, 25, 22, 23)
B <- c(28, 25, 24, 27, 30, 30, 29)
Tau_BC(A_data = A, B_data = B)

}
\references{
Tarlow, K. R. (2017). An improved rank correlation effect size
  statistic for single-case designs: Baseline corrected Tau. \emph{Behavior
  modification, 41}(4), 427-467. doi:\doi{10.1177/0145445516676750}
}
\seealso{
\code{\link{Tau}}, \code{\link{Tau_U}}
}
