% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVPedSim_Functions.R
\name{disqualify_ped}
\alias{disqualify_ped}
\title{Initial checks to disqualify a pedigree from ascertainment.}
\usage{
disqualify_ped(ped_file, num_affected, ascertain_span, first_diagnosis)
}
\arguments{
\item{ped_file}{An object of class \code{ped}. A pedigree generated by \code{sim_ped} or \code{sim_RVped}, or an object created by the function \code{\link{new.ped}}.  See details.}

\item{num_affected}{Numeric.  The minimum number of affected individuals in the pedigree.}

\item{ascertain_span}{Numeric vector of length 2.  The year span of the ascertainment period.  This period represents the range of years during which the proband developed disease and the family would have been ascertained for multiple affected relatives.}

\item{first_diagnosis}{Numeric. The first year that reliable diagnoses can be obtained regarding disease-affection status.  By default, \code{first_diagnosis}\code{ = NULL} so that all diagnoses are considered reliable. See details.}
}
\value{
Logical. If TRUE, pedigree is discarded.
}
\description{
Initial checks to disqualify a pedigree from ascertainment.
}
\keyword{internal}
