% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictPMCMC.R
\name{predict.PMCMC}
\alias{predict.PMCMC}
\title{Predicts future course of outbreak from \code{PMCMC} objects}
\usage{
\method{predict}{PMCMC}(object, tspan, npart = 50, ...)
}
\arguments{
\item{object}{A \code{PMCMC} object.}

\item{tspan}{A vector of times over which to output predictions.}

\item{npart}{The number of particles to use in the bootstrap filter.}

\item{...}{Not used here.}
}
\value{
A \code{SimBIID_runs} object.
}
\description{
Predict method for \code{PMCMC} objects.
}
\examples{
\donttest{
## set up data to pass to PMCMC
flu_dat <- data.frame(
    t = 1:14,
    Robs = c(3, 8, 26, 76, 225, 298, 258, 233, 189, 128, 68, 29, 14, 4)
)

## set up observation process
obs <- data.frame(
    dataNames = "Robs",
    dist = "pois",
    p1 = "R + 1e-5",
    p2 = NA,
    stringsAsFactors = FALSE
)

## set up model (no need to specify tspan
## argument as it is set in PMCMC())
transitions <- c(
    "S -> beta * S * I / (S + I + R + R1) -> I", 
    "I -> gamma * I -> R",
    "R -> gamma1 * R -> R1"
)
compartments <- c("S", "I", "R", "R1")
pars <- c("beta", "gamma", "gamma1")
model <- mparseRcpp(
    transitions = transitions, 
    compartments = compartments,
    pars = pars,
    obsProcess = obs
)

## set priors
priors <- data.frame(
    parnames = c("beta", "gamma", "gamma1"), 
    dist = rep("unif", 3), 
    stringsAsFactors = FALSE)
priors$p1 <- c(0, 0, 0)
priors$p2 <- c(5, 5, 5)

## define initial states
iniStates <- c(S = 762, I = 1, R = 0, R1 = 0)

## run PMCMC algorithm for first three days of data
post <- PMCMC(
    x = flu_dat[1:3, ], 
    priors = priors, 
    func = model, 
    u = iniStates, 
    npart = 75, 
    niter = 10000, 
    nprintsum = 1000
)

## plot traces
plot(post, "trace")

## run predictions forward in time
post_pred <- predict(
    window(post, start = 2000, thin = 8), 
    tspan = 4:14
)

## plot predictions
plot(post_pred, quant = c(0.6, 0.75, 0.95))
}

}
\seealso{
\code{\link{PMCMC}}, \code{\link{print.PMCMC}}, \code{\link{plot.PMCMC}}, \code{\link{summary.PMCMC}}
    \code{\link{window.PMCMC}}
}
