% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{CID.Louvain}
\alias{CID.Louvain}
\title{Detects community substructure by Louvain community detection}
\usage{
CID.Louvain(edges)
}
\arguments{
\item{edges}{A data frame or matrix with edges}
}
\value{
A character vector with the community substructures of the graph corresponding to Louvain clusters.
}
\description{
\code{CID.Louvain} determines Louvain clusters from an edge list.
}
\examples{
\dontrun{
# Loads edges
file.dir = "https://kleintools.hms.harvard.edu/tools/client_datasets/"
file = "CITESEQ_EXPLORATORY_CITESEQ_5K_PBMCS/FullDataset_v1_protein/edges.csv"
download.file(paste0(file.dir, file, "?raw=true"), destfile = "edges.csv")

# data.dir is your path to the "edges.csv" file
edges = CID.LoadEdges(data.dir = ".")

# get louvain clusters from edge list
clusters = CID.Louvain(edges)
}
}
