% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iranges-methods.R
\name{coverage,ChromatinAssay-method}
\alias{coverage,ChromatinAssay-method}
\alias{coverage}
\alias{coverage,Seurat-method}
\title{Coverage of a ChromatinAssay object}
\usage{
\S4method{coverage}{ChromatinAssay}(
  x,
  shift = 0L,
  width = NULL,
  weight = 1L,
  method = c("auto", "sort", "hash")
)

\S4method{coverage}{Seurat}(
  x,
  shift = 0L,
  width = NULL,
  weight = 1L,
  method = c("auto", "sort", "hash")
)
}
\arguments{
\item{x}{A \code{\link{ChromatinAssay}} object}

\item{shift}{How much each range should be shifted before coverage is
computed. See \code{\link[IRanges]{coverage}} in the \pkg{IRanges} package.}

\item{width}{Specifies the length of the returned coverage vectors.
See \code{\link[IRanges]{coverage}} in the \pkg{IRanges} package.}

\item{weight}{Assigns weight to each range in \code{x}.
See \code{\link[IRanges]{coverage}} in the \pkg{IRanges} package.}

\item{method}{See \code{\link[IRanges]{coverage}} in the \pkg{IRanges}
package}
}
\description{
This is the \code{coverage} method for \code{\link{ChromatinAssay}} objects.
}
\section{Functions}{
\itemize{
\item \code{coverage,ChromatinAssay-method}: method for ChromatinAssay objects

\item \code{coverage,Seurat-method}: method for Seurat objects
}}

\seealso{
\itemize{
  \item{\link[IRanges]{coverage-methods} in the \pkg{IRanges} package.}
  \item{\link[GenomicRanges]{coverage-methods} in the \pkg{GenomicRanges}
  package}
  \item{\link{ChromatinAssay-class}}
 }
}
\concept{coverage}
