% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistractorAnalysis.R
\name{DistractorAnalysis}
\alias{DistractorAnalysis}
\title{Distractor analysis}
\usage{
DistractorAnalysis(
  Data,
  key,
  item = "all",
  p.table = FALSE,
  num.groups = 3,
  criterion = NULL,
  crit.discrete = FALSE,
  cut.points,
  data,
  matching,
  match.discrete
)
}
\arguments{
\item{Data}{character: data matrix or data.frame with rows
representing unscored item responses from a multiple-choice test
and columns corresponding to the items.}

\item{key}{character: answer key for the items. The \code{key} must be a
vector of the same length as \code{ncol(Data)}. In case it is not
provided, \code{criterion} needs to be specified.}

\item{item}{numeric or character: either character \code{"all"} to
apply for all items (default), or a vector of item names (column
names of \code{Data}), or item identifiers (integers specifying
the column number).}

\item{p.table}{logical: should the function return the proportions?
If \code{FALSE} (default), the counts are returned.}

\item{num.groups}{numeric: number of groups to which are the
respondents split.}

\item{criterion}{numeric: numeric vector. If not provided, total
score is calculated and distractor analysis is performed based on
it.}

\item{crit.discrete}{logical: is \code{criterion} discrete? Default
value is \code{FALSE}. See details.}

\item{cut.points}{numeric: numeric vector specifying cut points of
\code{criterion}. See details.}

\item{data}{deprecated. Use argument \code{Data} instead.}

\item{matching}{deprecated. Use argument \code{criterion} instead.}

\item{match.discrete}{deprecated. Use argument \code{crit.discrete}
instead.}
}
\description{
Performs distractor analysis for each item and
optional number of groups.
}
\details{
This function is an adapted version of the
\code{distractor.analysis()} function from \pkg{CTT} package. In
case that no \code{criterion} is provided, the scores are calculated
using the item \code{Data} and \code{key}. The respondents are by default
split into the \code{num.groups}-quantiles and the number (or
proportion) of respondents in each quantile is reported with
respect to their answers. In case that \code{criterion} is discrete
(\code{crit.discrete = TRUE}), \code{criterion} is split based on its
unique levels. Other cut points can be specified via \code{cut.points}
argument.
}
\examples{
Data <- dataMedicaltest[, 1:100]
Databin <- dataMedical[, 1:100]
key <- dataMedicalkey

# distractor analysis for all items
DistractorAnalysis(Data, key)

# distractor analysis for item 1
DistractorAnalysis(Data, key, item = 1)
\dontrun{
# distractor analysis with proportions
DistractorAnalysis(Data, key, p.table = TRUE)

# distractor analysis for 6 groups
DistractorAnalysis(Data, key, num.group = 6)

# distractor analysis using specified criterion
criterion <- round(rowSums(Databin), -1)
DistractorAnalysis(Data, key, criterion = criterion)

# distractor analysis using discrete criterion
DistractorAnalysis(Data, key, criterion = criterion, crit.discrete = TRUE)

# distractor analysis using groups specified by cut.points
DistractorAnalysis(Data, key, cut.points = seq(10, 96, 10))
}

}
\author{
Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
