% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blis.R
\name{coef,BlisClass-method}
\alias{coef,BlisClass-method}
\title{Get Coefficients from a fitted BLIS model}
\usage{
\S4method{coef}{BlisClass}(
  object,
  ...,
  CI = 0.95,
  printSE = FALSE,
  IRTpars = FALSE,
  simplify = FALSE,
  labels = FALSE,
  mark_correct = labels
)
}
\arguments{
\item{object}{\emph{object of class \linkS4class{BlisClass}}, model fitted via
\code{fit_blis}() or \code{blis()}.}

\item{...}{Additional arguments. Not utilized at the moment.}

\item{CI}{\emph{numeric}, a width of the confidence intervals.}

\item{printSE}{\emph{logical}, print standard errors instead of CI? Defaults to
\code{FALSE}.}

\item{IRTpars}{\emph{logical}, convert slope intercept parameters into IRT
parameters (i.e. BLIRT)? Defaults to \code{FALSE}.}

\item{simplify}{\emph{logical}, return coefficients as a matrix, instead of list?
Defaults to \code{FALSE}. \emph{Not implemented yet.}}

\item{labels}{\emph{logical}, if \code{TRUE}, show response labels (e.g. "A", "B", "C")
instead of response numeric indices (e.g. 0, 1, 2). Defaults to \code{FALSE}.}

\item{mark_correct}{\emph{logical}, mark the correct response with an asterisk
symbol. Applicable only if \code{labels} is \code{TRUE} (in which case,
\code{mark_correct} defaults to \code{TRUE}).}
}
\value{
List of item coefficients of S3 class \code{blis_coefs}, so the resulting
output of \code{coef()} call is formatted to display only first 3 digits (you
can opt for different rounding via the \link{print.blis_coefs} method, see the
examples). Note that the list-object returned invisibly has the raw
coefficients stored in it.
}
\description{
Extracts item parameters from fitted BLIS model. For BLIRT parametrization,
use \code{IRTpars = TRUE} in your function call. Contrary to
\link{coef,SingleGroupClass-method}, response category labels can be displayed in
the output using \code{labels = TRUE}. On top of that, as BLIS/BLIRT
parametrizations utilize the information of correct response category, you
can denote these in the output with \code{mark_correct = TRUE}.
}
\examples{
fitted_blis <- fit_blis(HCItest[, 1:20], HCIkey)

# BLIS coefs
coef(fitted_blis)

# BLIRT coefs
coef(fitted_blis, IRTpars = TRUE)

# store raw coefs
blis_coefs <- coef(fitted_blis)

# print coefs rounded to 2 digits
print(blis_coefs, digits = 2)

}
\seealso{
Other BLIS/BLIRT related: 
\code{\link{BlisClass-class}},
\code{\link{fit_blis}()},
\code{\link{get_orig_levels}()},
\code{\link{nominal_to_int}()},
\code{\link{obtain_nrm_def}()},
\code{\link{print.blis_coefs}()}
}
\concept{BLIS/BLIRT related}
