#' Key of correct answers for homeostasis concept inventory dataset
#'
#' @description The `HCIkey` is a vector of factors representing correct
#'   answers of `HCItest` dataset.
#'
#' @usage data(HCIkey)
#'
#' @author Jenny L. McFarland \cr Biology Department, Edmonds Community College
#'
#' @references McFarland, J. L., Price, R. M., Wenderoth, M. P., Martinkova, P.,
#' Cliff, W., Michael, J., ... & Wright, A. (2017). Development and validation
#' of the homeostasis concept inventory. CBE-Life Sciences Education, 16(2),
#' ar35. \doi{10.1187/cbe.16-10-0305}
#'
#' @keywords datasets
#'
#' @seealso
#' [HCItest()] for HCI multiple-choice dataset\cr
#' [HCI()] for HCI dichotomous dataset\cr
#' [HCIdata()] for HCI full dataset\cr
#' [HCIgrads()]  for HCI dataset of graduate students\cr
#' [HCIprepost()] for HCI pretest and posttest scores\cr
#' [HCItestretest()] for HCI test-retest dataset
#'
#' @format A nominal vector with 20 values representing correct answers to items
#'   of `HCItest` dataset. For more details see [HCItest()].
"HCIkey"
