% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{JackStraw}
\alias{JackStraw}
\title{Determine statistical significance of PCA scores.}
\usage{
JackStraw(object, reduction = "pca", assay = NULL, dims = 20,
  num.replicate = 100, prop.freq = 0.01, verbose = TRUE,
  maxit = 1000)
}
\arguments{
\item{object}{Seurat object}

\item{reduction}{DimReduc to use. ONLY PCA CURRENTLY SUPPORTED.}

\item{assay}{Assay used to calculate reduction.}

\item{dims}{Number of PCs to compute significance for}

\item{num.replicate}{Number of replicate samplings to perform}

\item{prop.freq}{Proportion of the data to randomly permute for each
replicate}

\item{verbose}{Print progress bar showing the number of replicates
that have been processed.}

\item{maxit}{maximum number of iterations to be performed by the irlba function of RunPCA}
}
\value{
Returns a Seurat object where JS(object = object[['pca']], slot = 'empirical')
represents p-values for each gene in the PCA analysis. If ProjectPCA is
subsequently run, JS(object = object[['pca']], slot = 'full') then
represents p-values for all genes.
}
\description{
Randomly permutes a subset of data, and calculates projected PCA scores for
these 'random' genes. Then compares the PCA scores for the 'random' genes
with the observed PCA scores to determine statistical signifance. End result
is a p-value for each gene's association with each principal component.
}
\examples{
\dontrun{
pbmc_small = suppressWarnings(JackStraw(pbmc_small))
head(JS(object = pbmc_small[['pca']], slot = 'empirical'))
}

}
\references{
Inspired by Chung et al, Bioinformatics (2014)
}
