% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{Idents}
\alias{Idents}
\alias{Idents<-}
\alias{RenameIdents}
\alias{RenameIdent}
\alias{ReorderIdent}
\alias{SetIdent}
\alias{StashIdent}
\alias{Idents.Seurat}
\alias{Idents<-.Seurat}
\alias{ReorderIdent.Seurat}
\alias{RenameIdents.Seurat}
\alias{SetIdent.Seurat}
\alias{StashIdent.Seurat}
\alias{levels.Seurat}
\alias{levels<-.Seurat}
\title{Get, set, and manipulate an object's identity classes}
\usage{
Idents(object, ...)

Idents(object, ...) <- value

RenameIdents(object, ...)

ReorderIdent(object, var, ...)

SetIdent(object, ...)

StashIdent(object, save.name, ...)

\method{Idents}{Seurat}(object, ...)

\method{Idents}{Seurat}(object, cells = NULL, drop = FALSE,
  ...) <- value

\method{ReorderIdent}{Seurat}(object, var, reverse = FALSE,
  afxn = mean, reorder.numeric = FALSE, ...)

\method{RenameIdents}{Seurat}(object, ...)

\method{SetIdent}{Seurat}(object, cells = NULL, value, ...)

\method{StashIdent}{Seurat}(object, save.name = "orig.ident", ...)

\method{levels}{Seurat}(x)

\method{levels}{Seurat}(x) <- value
}
\arguments{
\item{...}{Arguments passed to other methods; for \code{RenameIdents}: named
arguments as \code{old.ident = new.ident}; for \code{ReorderIdent}: arguments
passed on to \code{\link{FetchData}}}

\item{value}{The name of the identites to pull from object metadata or the identities themselves}

\item{var}{Feature or variable to order on}

\item{save.name}{Store current identity information under this name}

\item{cells}{Set cell identities for specific cells}

\item{drop}{Drop unused levels}

\item{reverse}{Reverse ordering}

\item{afxn}{Function to evaluate each identity class based on; default is
\code{\link[base]{mean}}}

\item{reorder.numeric}{Rename all identity classes to be increasing numbers
starting from 1 (default is FALSE)}

\item{x, object}{An object}
}
\value{
\code{Idents}: The cell identies

\code{Idents<-}: An object with the cell identites changed

\code{RenameIdents}: An object with selected identity classes renamed

\code{ReorderIdent}: An object with

\code{SetIdent}: An object with new identity classes set

\code{StashIdent}: An object with the identities stashed
}
\description{
Get, set, and manipulate an object's identity classes
}
\examples{
# Get cell identity classes
Idents(object = pbmc_small)

# Set cell identity classes
# Can be used to set identities for specific cells to a new level
Idents(object = pbmc_small, cells = 1:4) <- 'a'
head(x = Idents(object = pbmc_small))

# Can also set idents from a value in object metadata
colnames(x = pbmc_small[[]])
Idents(object = pbmc_small) <- 'RNA_snn_res.1'
levels(x = pbmc_small)

# Rename cell identity classes
# Can provide an arbitrary amount of idents to rename
levels(x = pbmc_small)
pbmc_small <- RenameIdents(object = pbmc_small, '0' = 'A', '2' = 'C')
levels(x = pbmc_small)

\dontrun{
head(x = Idents(object = pbmc_small))
pbmc_small <- ReorderIdent(object = pbmc_small, var = 'PC_1')
head(x = Idents(object = pbmc_small))
}

# Set cell identity classes using SetIdent
cells.use <- WhichCells(object = pbmc_small, idents = '1')
pbmc_small <- SetIdent(object = pbmc_small, cells = cells.use, value = 'B')

head(x = pbmc_small[[]])
pbmc_small <- StashIdent(object = pbmc_small, save.name = 'idents')
head(x = pbmc_small[[]])

# Get the levels of identity classes of a Seurat object
levels(x = pbmc_small)

# Reorder identity classes
levels(x = pbmc_small)
levels(x = pbmc_small) <- c('C', 'A', 'B')
levels(x = pbmc_small)

}
