\name{SetMethods-package}
\alias{SetMethods-package}
\alias{SetMethods}
\docType{package}
\title{Functions for Set-Theoretic Multi-Method Research and Advanced QCA}
\description{This initiated as a package companion to the book by C. Q. Schneider and C. Wagemann "Set-Theoretic Methods for the Social Sciences", Cambridge University Press. It has now grown to include functions for performing set-theoretic multi-method research (Schneider 2023, Schneider and Rohlfing 2013), QCA for clustered data (Garcia-Castro and Arino 2013), theory evaluation, Enhanced Standard Analysis, QCA Radar Charts, indirect calibration, robustness tests (Oana and Schneider - 2021) etc.. Additionally it includes data to replicate the examples in the book by Oana, I.E, C. Q. Schneider, and E. Thomann. Qualitative Comparative Analysis (QCA) using R: A Gentle Introduction. Cambridge University Press and C. Q. Schneider and C. Wagemann "Set Theoretic Methods for the Social Sciences", 2021, Cambridge University Press.
}
\details{
\tabular{ll}{
Package: \tab SetMethods\cr
Type: \tab Package\cr
Version: \tab 4.0\cr
Date: \tab 2023-03-29\cr
License: \tab GPL-2\cr
}
The package contains functions to perform set-theoretic multi-method research, theory evaluation, QCA for clustered data, Enhanced Standard Analyses, indirect calibration, calculate parameters of fit and produce XY plots and QCA Radar Charts, perform robustness tests, etc.. Furthermore, it contains all the data used in the Schneider and Wagemann (2012) and Oana, Schneider, and Thomann (2021) books.}
\author{
Ioana-Elena Oana [aut, cre], Juraj Medzihorsky [aut], Carsten Q. Schneider [aut], Mario Quaranta [aut]

Maintainer: Ioana-Elena Oana <ioana.oana@eui.eu>
}
\references{
Schneider, C. Q. (2023). Set-Theoretic Multi-Method Research: A Guide to Combining QCA and Case Studies. Cambridge: Cambridge University Press.

Oana, I.E., Schneider, C. Q., Thomann, E. (2021). Qualitative Comparative Analysis (QCA) using R: A Beginner's Guide. Cambridge: Cambridge University Press.

Oana, I.E., Schneider, C. Q. (2021). A Robustness Test Protocol for Applied QCA: Theory and R Software Application. Sociological Methods and Research. https://doi.org/10.1177/00491241211036158.

Oana, I.E., Schndeider, C.Q. (2018) SetMethods: An Add-on R Package for Advanced QCA.The R Journal 10(1): 507-33.

Schneider, C. Q., Wagemann, C. (2012) Set-Theoretic Methods for the Social Sciences, Cambridge University Press: Cambridge

Schneider, C. Q., Rohlfing, I. (2013) Combining QCA and Process Tracing in Set-Theoretic Multi-Method Research. Sociological Methods Research 42(4): 559-597

Haesebrouck, T. (2015) Pitfalls in QCA's consistency measure. Journal of Comparative Politics 2:65-80.

Garcia-Castro, A., Arino, M. A.. (2013) A General Approach to Panel Data Set-Theoretic Research. COMPASSS Working Paper 2013-76

}
%\keyword{}
%\seealso{}
%\examples{}
