% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensusR.R
\name{sensus.read.json.files}
\alias{sensus.read.json.files}
\title{Read JSON-formatted Sensus data.}
\usage{
sensus.read.json.files(data.path, is.directory = TRUE,
  recursive = TRUE, local.timezone = Sys.timezone(),
  data.types = NULL)
}
\arguments{
\item{data.path}{Path to Sensus JSON data (either a file or a directory).}

\item{is.directory}{Whether or not the path is a directory.}

\item{recursive}{Whether or not to read files recursively from directory indicated by path.}

\item{local.timezone}{The local timezone to convert datum timestamps to, or NULL to leave the timestamps unconverted.}

\item{data.types}{Specific data types to read. A full list of data types can be found here:  \url{https://predictive-technology-laboratory.github.io/sensus/api/Sensus.Datum.html}. For example \code{c("AccelerometerDatum", "HeightDatum")} will only read accelerometer and height data. Pass \code{NULL} to read all data types.}
}
\value{
All data, listed by type.
}
\description{
Read JSON-formatted Sensus data.
}
\examples{
# data.path = system.file("extdata", "example-data", package="SensusR")	
# data = sensus.read.json.files(data.path)
}
